/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.log.ExoLogger;

public class GetNodesAndPropertiesTest
extends JCRTestBase {
    protected static Log log = ExoLogger.getLogger((String)"GetNodesAndPropertiesTest");

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Session session = context.getSession();
        String rootName = tc.getParam("jcr.rootNodeName");
        try {
            log.info((Object)("Get nodes start in " + rootName));
            Node node = (Node)session.getItem(rootName);
            int pcount = 0;
            PropertyIterator piter = node.getProperties();
            while (piter.hasNext()) {
                try {
                    piter.nextProperty().getString();
                }
                catch (ValueFormatException e) {
                    log.error((Object)e);
                }
                ++pcount;
            }
            NodeIterator ni = node.getNodes();
            int ncount = 0;
            while (ni.hasNext()) {
                ni.nextNode();
                ++ncount;
            }
            log.info((Object)("Get nodes " + ncount + " (" + pcount + " properties) time in report "));
        }
        catch (PathNotFoundException e) {
            log.error((Object)e);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
    }
}

