/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

public class PropertyRemoveTest
extends AbstractGetItemTest {
    private int propertyType1Count;
    private int propertyType2Count;
    private static final String PROPERTY_NAME = "prop";

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Random generator;
        byte[] binaryValue;
        int i;
        Node testNode = parent.addNode(context.generateUniqueName("testNode"));
        this.addNode(testNode);
        this.propertyType1Count = tc.getIntParam("usecase.propertyType1Count");
        this.propertyType2Count = tc.getIntParam("usecase.propertyType1Count");
        Value[] values = new Value[this.propertyType1Count + this.propertyType2Count];
        Property prop = null;
        for (i = 0; i < this.propertyType1Count; ++i) {
            int propertyType1Size = tc.getIntParam("usecase.propertyType1SizeInKb") * 1024;
            binaryValue = new byte[propertyType1Size];
            generator = new Random();
            generator.nextBytes(binaryValue);
            values[i] = testNode.getSession().getValueFactory().createValue((InputStream)new ByteArrayInputStream(binaryValue));
        }
        for (i = 0; i < this.propertyType2Count; ++i) {
            int propertyType2Size = tc.getIntParam("usecase.propertyType2SizeInKb") * 1024;
            binaryValue = new byte[propertyType2Size];
            generator = new Random();
            generator.nextBytes(binaryValue);
            values[this.propertyType1Count + i] = testNode.getSession().getValueFactory().createValue((InputStream)new ByteArrayInputStream(binaryValue));
        }
        prop = values.length == 1 ? testNode.setProperty(PROPERTY_NAME, values[0]) : testNode.setProperty(PROPERTY_NAME, values);
        testNode.getSession().save();
        this.addProperty(prop);
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Property prop = this.nextProperty();
        Session session = prop.getSession();
        prop.remove();
        session.save();
    }
}

