/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.MembershipType;

public abstract class AbstractMembershipTypeTest
extends AbstractOrganizationTest {
    private List<MembershipType> mts;
    private int index = 0;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        this.mts = new ArrayList<MembershipType>();
        int runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            runIterations += warmUpIterations;
        }
        for (int i = 0; i < runIterations; ++i) {
            MembershipType mt = this.mtHandler.createMembershipTypeInstance();
            mt.setName(context.generateUniqueName("membershiptype"));
            this.mts.add(mt);
        }
    }

    protected void createContent() throws Exception {
        for (MembershipType mt : this.mts) {
            this.mtHandler.createMembershipType(mt, false);
        }
        this.mts.clear();
        this.mts = (List)this.mtHandler.findMembershipTypes();
        for (int i = this.mts.size() - 1; i >= 0; --i) {
            if (this.mts.get(i).getName().startsWith("membershiptype")) continue;
            this.mts.remove(i);
        }
    }

    protected MembershipType nextMembershipType() {
        return this.mts.get(this.index++);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        for (MembershipType mt : this.mts) {
            String name = mt.getName();
            if ((mt = this.mtHandler.findMembershipType(name)) == null) continue;
            this.mtHandler.removeMembershipType(name, false);
        }
        this.mts.clear();
        this.mts = null;
        super.doFinish(tc, context);
    }
}

