/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.Params;
import com.sun.japex.ParamsImpl;
import com.sun.japex.TestCase;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestBase;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class AsyncDriver
extends JapexDriverBase {
    protected Repository repository;
    protected AsyncReplication replication;
    protected Session oneSession;
    protected Credentials credentials;
    protected String workspace;
    protected AsyncTestContext context;
    private AsyncTestBase test;

    public void initializeDriver() {
        if (!this.hasParam("jcr.user")) {
            throw new RuntimeException("<jcr.user> parameter required");
        }
        if (!this.hasParam("jcr.password")) {
            throw new RuntimeException("<jcr.password> parameter required");
        }
        if (!this.hasParam("jcr.workspace")) {
            throw new RuntimeException("<jcr.workspace> parameter required");
        }
        String user = this.getParam("jcr.user");
        String password = this.getParam("jcr.password");
        ParamsImpl params = new ParamsImpl();
        params.setParam("exo.jaasConf", this.getParam("exo.jaasConf"));
        params.setParam("exo.containerConf", this.getParam("exo.containerConf"));
        try {
            this.initialize((Params)params);
            this.workspace = this.getParam("jcr.workspace");
            this.credentials = new SimpleCredentials(user, password.toCharArray());
            this.oneSession = this.repository.login(this.credentials, this.workspace);
            this.context = new AsyncTestContext();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void prepare(TestCase tc) {
        try {
            this.context = this.initContext(tc, this.context);
            this.test = this.testInstance(tc);
            this.test.doPrepare(tc, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void run(TestCase tc) {
        try {
            this.test.doRun(tc, this.context);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Session s = this.context.getSession();
                if (s != null) {
                    s.refresh(false);
                }
            }
            catch (RepositoryException e1) {
                System.err.println("Can not refresh test session. Reason: " + e1.getMessage());
            }
        }
    }

    public void finish(TestCase tc) {
        try {
            this.test.doFinish(tc, this.context);
            this.context.getSession().logout();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private synchronized AsyncTestBase testInstance(TestCase tc) {
        if (!tc.hasParam("exo.testClass")) {
            throw new RuntimeException("<exo.testClass> parameter required");
        }
        try {
            String testCaseName = tc.getParam("exo.testClass");
            return (AsyncTestBase)Class.forName(testCaseName).newInstance();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private synchronized AsyncTestContext initContext(TestCase tc, AsyncTestContext context) {
        if (!this.hasParam("jcr.sessionPolicy")) {
            throw new RuntimeException("<jcr.sessionPolicy> parameter required");
        }
        String sessionPolicy = this.getParam("jcr.sessionPolicy");
        if (sessionPolicy.equalsIgnoreCase("single")) {
            context.setSession(this.oneSession);
            context.setCredentials(this.credentials);
            context.setReplicationServer(this.replication);
        } else if (sessionPolicy.equalsIgnoreCase("multiple")) {
            try {
                context.setSession(this.repository.login(this.credentials, this.workspace));
                context.setCredentials(this.credentials);
                context.setReplicationServer(this.replication);
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("<sessionPolicy> parameter expects 'single' or 'multiple' values. Found " + sessionPolicy);
        }
        return context;
    }

    private void initialize(Params params) {
        if (!params.hasParam("exo.jaasConf")) {
            throw new RuntimeException("<exo.jaasConf> parameter required");
        }
        if (!params.hasParam("exo.containerConf")) {
            throw new RuntimeException("<exo.containerConf> parameter required");
        }
        String jaasConf = params.getParam("exo.jaasConf");
        String containerConf = params.getParam("exo.containerConf");
        try {
            StandaloneContainer.addConfigurationPath((String)containerConf);
            StandaloneContainer container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource(jaasConf).toString());
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            this.repository = repositoryService.getCurrentRepository();
            System.out.println();
            this.replication = (AsyncReplication)container.getComponentInstanceOfType(AsyncReplication.class);
            if (this.replication == null) {
                throw new NullPointerException("Replication is null");
            }
            System.out.println("REPLICATION -" + this.replication.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

