/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestBase;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class ConflictSunchronizeMoveTest
extends AsyncTestBase {
    public static String FOLDER_NAME = "conflictMoveFolder";
    public Node root;

    public void doPrepare(TestCase tc, AsyncTestContext context) throws Exception {
        super.doPrepare(tc, context);
        Session s = context.getSession();
        String rootFolder = tc.getParam("ext.rootFolder");
        this.root = s.getRootNode().addNode(rootFolder);
        s.save();
    }

    public void doRun(TestCase tc, AsyncTestContext context) throws Exception {
        Session s = context.getSession();
        s.getRootNode().addNode(FOLDER_NAME);
        s.save();
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Synchronize root folder started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronize root folder ended.");
        for (int i = 0; i < this.sc; ++i) {
            for (int j = 0; j < this.fc; ++j) {
                Node nodeToAdd = this.root.addNode("node_" + i + "_" + j, "nt:file");
                Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
            }
            s.save();
            log.info((Object)(i + " log saved"));
        }
        log.info((Object)" MOVE to dest folder ");
        NodeIterator it = this.root.getNodes();
        while (it.hasNext()) {
            s.move(it.nextNode().getPath(), "/" + FOLDER_NAME + "/" + it.nextNode().getName());
            s.save();
        }
        rep.synchronize();
        log.info((Object)"Synchronize MOVE started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronize MOVE done.");
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        Session s = context.getSession();
        if (s.getRootNode().hasNode(FOLDER_NAME)) {
            this.root = s.getRootNode().getNode(FOLDER_NAME);
            this.root.remove();
            s.save();
        }
        super.doFinish(tc, context);
    }
}

