/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestBase;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class ConflictVersionTest
extends AsyncTestBase {
    public static String FOLDER_NAME = "conflictFolder";
    public Node root;

    public void doPrepare(TestCase tc, AsyncTestContext context) throws Exception {
        super.doPrepare(tc, context);
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Previous synchronization started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Previous synchronization done.");
        Session s = context.getSession();
        this.root = s.getRootNode().addNode(FOLDER_NAME);
        this.root.addMixin("mix:versionable");
        s.save();
    }

    public void doRun(TestCase tc, AsyncTestContext context) throws Exception {
        int i;
        Node contentNodeOfNodeToAdd;
        int j;
        int i2;
        Session s = context.getSession();
        for (i2 = 0; i2 < this.sc; ++i2) {
            for (j = 0; j < this.fc; ++j) {
                Node nodeToAdd = this.root.addNode("node_" + i2 + "_" + j, "nt:file");
                nodeToAdd.addMixin("mix:versionable");
                contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
            }
            s.save();
            log.info((Object)(i2 + " log saved"));
        }
        log.info((Object)"Checkin");
        this.root.checkin();
        for (i2 = 0; i2 < this.sc; ++i2) {
            for (j = 0; j < this.fc; ++j) {
                this.root.getNode("node_" + i2 + "_" + j).checkin();
            }
        }
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Synchronize ADD started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        this.root = s.getRootNode().getNode(FOLDER_NAME);
        this.root.checkout();
        for (i = 0; i < this.sc; ++i) {
            for (int j2 = 0; j2 < this.fc; ++j2) {
                this.root.getNode("node_" + i + "_" + j2).checkout();
            }
        }
        log.info((Object)"Synchronization ADD  done.");
        log.info((Object)"add nodes");
        for (i = 0; i < 5; ++i) {
            Node nodeToAdd = this.root.addNode("node_s_" + i, "nt:file");
            contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
            contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
            contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
            contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
        }
        s.save();
        log.info((Object)"update properties");
        for (i = 0; i < 10; ++i) {
            Node node = this.root.getNode("node_" + i + "_" + 2);
            node.getNode("jcr:content").setProperty("jcr:data", "blabla");
        }
        s.save();
        String pr = tc.getParam("ext.nodePriority");
        if (pr.equalsIgnoreCase("high")) {
            log.info((Object)"restore few nodes");
            for (int i3 = 0; i3 < 5; ++i3) {
                Node node = this.root.getNode("node_" + i3 + "_" + 2);
                Version baseVersion = node.getBaseVersion();
                node.restore(baseVersion, true);
                s.save();
            }
        } else if (pr.equalsIgnoreCase("low")) {
            log.info((Object)"restore folder");
            Version baseVersion = this.root.getBaseVersion();
            this.root.restore(baseVersion, true);
            s.save();
        } else {
            throw new Exception("Invalid parameter ext.nodePriority [" + pr + "]");
        }
        rep.synchronize();
        log.info((Object)"Synchronize RESTORE started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronization RESTORE  done.");
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        Session s = context.getSession();
        if (s.getRootNode().hasNode(FOLDER_NAME)) {
            this.root = s.getRootNode().getNode(FOLDER_NAME);
            this.root.remove();
            s.save();
        }
        super.doFinish(tc, context);
    }
}

