/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestBase;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class LoadFilesAndSynchronizeTest
extends AsyncTestBase {
    private Node root;

    public void doPrepare(TestCase tc, AsyncTestContext context) throws Exception {
        super.doPrepare(tc, context);
        String rootFolder = tc.getParam("ext.rootFolder");
        Session s = context.getSession();
        this.root = s.getRootNode().addNode(rootFolder);
        s.save();
    }

    public void doRun(TestCase tc, AsyncTestContext context) throws Exception {
        Session s = context.getSession();
        for (int i = 0; i < this.sc; ++i) {
            for (int j = 0; j < this.fc; ++j) {
                Node nodeToAdd = this.root.addNode("node_" + i + "_" + j, "nt:file");
                Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "application/pdf");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
            }
            s.save();
            log.info((Object)(i + " log saved"));
        }
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Synchronize started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        String opRootName = tc.getParam("ext.oponentRootFolder");
        if (!s.getRootNode().hasNode(opRootName)) {
            log.info((Object)"FAIL: there is no merged opponent folder.");
        } else {
            log.info((Object)"OK : opponent folder is merged.");
            Node opRoot = s.getRootNode().getNode(opRootName);
            if (opRoot.getNodes().getSize() != (long)(this.sc * this.fc)) {
                log.info((Object)("FAIL: add files count is not expected. There is " + opRoot.getNodes().getSize() + " but must " + this.sc * this.fc));
            } else {
                log.info((Object)"OK : opponent files is added.");
            }
        }
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        this.root.remove();
        context.getSession().save();
    }
}

