/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestBase;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class SimpleVersionTest
extends AsyncTestBase {
    public static String FOLDER_NAME = "conflictFolder";
    public Node root;

    public void doPrepare(TestCase tc, AsyncTestContext context) throws Exception {
        super.doPrepare(tc, context);
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Previous synchronization started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Previous synchronization done.");
        Session s = context.getSession();
        this.root = s.getRootNode().addNode(FOLDER_NAME);
        this.root.addMixin("mix:versionable");
        s.save();
    }

    public void doRun(TestCase tc, AsyncTestContext context) throws Exception {
        Node contentNodeOfNodeToAdd;
        Node nodeToAdd;
        int j;
        int i;
        Session s = context.getSession();
        for (i = 0; i < this.sc; ++i) {
            for (j = 0; j < this.fc; ++j) {
                nodeToAdd = this.root.addNode("node_" + i + "_" + j, "nt:file");
                nodeToAdd.addMixin("mix:versionable");
                contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
            }
            s.save();
            log.info((Object)(i + " log saved"));
        }
        log.info((Object)"Checkin");
        this.root.checkin();
        for (i = 0; i < this.sc; ++i) {
            for (j = 0; j < this.fc; ++j) {
                this.root.getNode("node_" + i + "_" + j).checkin();
            }
        }
        this.root.checkout();
        for (i = 0; i < this.sc; ++i) {
            for (j = 0; j < this.fc; ++j) {
                this.root.getNode("node_" + i + "_" + j).checkout();
            }
        }
        String pr = tc.getParam("ext.nodePriority");
        if (pr.equalsIgnoreCase("high")) {
            log.info((Object)"restore few nodes");
            for (j = 0; j < 5; ++j) {
                nodeToAdd = this.root.addNode("node_3_" + j, "nt:file");
                nodeToAdd.addMixin("mix:versionable");
                contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
                s.save();
            }
        } else if (pr.equalsIgnoreCase("low")) {
            for (j = 5; j < 8; ++j) {
                nodeToAdd = this.root.addNode("node_2_" + j, "nt:file");
                nodeToAdd.addMixin("mix:versionable");
                contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
                s.save();
            }
        } else {
            throw new Exception("Invalid parameter ext.nodePriority [" + pr + "]");
        }
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Synchronize ADD started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronization ADD  done.");
        log.info((Object)"Synchronization restore done.");
        this.root = s.getRootNode().getNode(FOLDER_NAME);
        Version v = this.root.getBaseVersion();
        this.root.restore(v, true);
        rep.synchronize();
        log.info((Object)"Synchronize RESTORE started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronization RESTORE  done.");
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        Session s = context.getSession();
        if (s.getRootNode().hasNode(FOLDER_NAME)) {
            this.root = s.getRootNode().getNode(FOLDER_NAME);
            this.root.remove();
            s.save();
        }
        super.doFinish(tc, context);
    }
}

