/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractAddItemTest
extends JCRTestBase {
    private List<Node> parents = new ArrayList<Node>();
    private volatile int iteration = 0;
    protected Node rootNode = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        Session session = context.getSession();
        this.rootNode = session.getRootNode().addNode(context.generateUniqueName("rootNode"));
        session.save();
        int runIterations = tc.getIntParam("japex.runIterations");
        Node parent = null;
        for (int i = 0; i < runIterations; ++i) {
            if (i % 100 == 0) {
                parent = this.rootNode.addNode(context.generateUniqueName("parentNode"));
                this.rootNode.save();
            }
            this.addParent(parent);
            this.createContent(parent, tc, context);
        }
    }

    protected abstract void createContent(Node var1, TestCase var2, JCRTestContext var3) throws Exception;

    protected Node nextParent() {
        return this.parents.get(this.iteration++);
    }

    protected void addParent(Node parent) {
        this.parents.add(parent);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.refresh(false);
        for (Node parent : this.parents) {
            try {
                parent.remove();
            }
            catch (InvalidItemStateException e) {
                // empty catch block
            }
            this.rootNode.save();
        }
        this.rootNode.remove();
        context.getSession().save();
        this.parents.clear();
        this.parents = null;
    }
}

