/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractItemsTest
extends JCRTestBase {
    protected Node rootNode = null;
    protected String rootNodeName = "";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int runIterations = tc.getIntParam("japex.runIterations");
        if (runIterations <= 0) {
            throw new Exception("japex.runIterations should be a positive number, but " + runIterations);
        }
        Session session = context.getSession();
        this.rootNodeName = context.generateUniqueName("rootNode");
        this.rootNode = session.getRootNode().addNode(this.rootNodeName);
        session.save();
        Node parent = null;
        for (int i = 0; i < runIterations; ++i) {
            if (i % 100 == 0) {
                parent = this.rootNode.addNode(context.generateUniqueName("node"));
                this.rootNode.save();
            }
            this.createContent(parent, tc, context);
        }
        session.save();
    }

    protected abstract void createContent(Node var1, TestCase var2, JCRTestContext var3) throws Exception;

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.refresh(false);
        NodeIterator nodes = this.rootNode.getNodes();
        while (nodes.hasNext()) {
            nodes.nextNode().remove();
            this.rootNode.save();
        }
        this.rootNode.remove();
        context.getSession().save();
    }
}

