/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3ValueIOUtil;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.log.ExoLogger;

public abstract class S3ValueStorage
extends ValueStoragePlugin {
    protected static Log logger = ExoLogger.getLogger((String)"SimpleS3ValueStorage");
    public static final String BUCKET = "bucket";
    public static final String AWS_ACCESS_KEY = "aws-access-key";
    public static final String AWS_SECRET_ACCESS_KEY = "aws-secret-access-key";
    public static final String S3_SWAP_DIRECTORY = "s3-swap-directory";
    protected String bucket;
    protected String awsAccessKey;
    protected String awsSecretAccessKey;
    protected File s3SwapDirectory;
    protected final FileCleaner cleaner = new FileCleaner();

    public void init(Properties props) throws IOException, RepositoryConfigurationException {
        this.bucket = props.getProperty(BUCKET);
        this.awsAccessKey = props.getProperty(AWS_ACCESS_KEY);
        this.awsSecretAccessKey = props.getProperty(AWS_SECRET_ACCESS_KEY);
        this.s3SwapDirectory = new File(props.getProperty(S3_SWAP_DIRECTORY));
        if (!this.s3SwapDirectory.exists()) {
            if (this.s3SwapDirectory.mkdirs()) {
                logger.info((Object)("Created S3 swap directory " + this.s3SwapDirectory.getAbsolutePath()));
            } else {
                logger.warn((Object)("Can't created S3 swap directory " + this.s3SwapDirectory.getAbsolutePath()));
            }
        }
        S3ValueIOUtil.createBucket(this.bucket, this.awsAccessKey, this.awsSecretAccessKey);
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
    }

    public boolean match(String storageId) {
        return this.getId().equals(storageId);
    }
}

