/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import com.amazon.s3.AWSAuthConnection;
import com.amazon.s3.GetResponse;
import com.amazon.s3.ListBucketResponse;
import com.amazon.s3.ListEntry;
import com.amazon.s3.Response;
import com.amazon.s3.S3Object;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFileStreamValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;
import org.exoplatform.services.log.ExoLogger;

public class S3ValueIOUtil {
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.S3ValueIOUtil");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueData readValue(String bucket, String awsAccessKey, String awsSecretAccessKey, String s3fielName, int orderNum, int maxBufferSize, File swapDir, FileCleaner cleaner) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        GetResponse resp = conn.get(bucket, s3fielName, null);
        int responseCode = resp.connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Failed read data from S3 storage. HTTP status " + responseCode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read from S3: STATUS = " + responseCode));
        }
        int size = resp.connection.getContentLength();
        InputStream in = resp.connection.getInputStream();
        if (size > maxBufferSize) {
            SwapFile swapFile = SwapFile.get((File)swapDir, (String)s3fielName);
            if (!swapFile.isSpooled()) {
                try {
                    FileOutputStream fout = new FileOutputStream((File)swapFile);
                    try {
                        FileChannel fch = fout.getChannel();
                        ReadableByteChannel inch = Channels.newChannel(in);
                        long actualSize = fch.transferFrom(inch, 0L, size);
                        if ((long)size != actualSize) {
                            LOG.warn((Object)("Actual S3 Value size (" + actualSize + ") and content-length (" + size + ") differs. S3 key " + s3fielName));
                        }
                    }
                    finally {
                        fout.close();
                    }
                }
                finally {
                    swapFile.spoolDone();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Value created as CleanableFileStreamValueData");
            }
            return new CleanableFileStreamValueData(swapFile, orderNum, cleaner);
        }
        int rd = -1;
        byte[] buff = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((rd = in.read(buff)) != -1) {
            out.write(buff, 0, rd);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Value created as ByteArrayPersistedValueData");
        }
        return new ByteArrayPersistedValueData(out.toByteArray(), orderNum);
    }

    public static boolean isValueExists(String bucket, String awsAccessKey, String awsSecretAccessKey, String s3fielName) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        GetResponse resp = conn.get(bucket, s3fielName, null);
        int responseCode = resp.connection.getResponseCode();
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Read from S3: STATUS = " + responseCode));
        }
        return responseCode == 200;
    }

    public static void createBucket(String bucket, String awsAccessKey, String awsSecretAccessKey) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        Response resp = conn.createBucket(bucket, null);
        int responseCode = resp.connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Can't create BUCKET on S3 storage. HTTP status " + responseCode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create bucket on S3: STATUS = " + responseCode));
        }
    }

    public static void deleteBucket(String bucket, String awsAccessKey, String awsSecretAccessKey) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        Response resp = conn.deleteBucket(bucket, null);
        int responseCode = resp.connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Can't delete BUCKET on S3 storage. HTTP status " + responseCode + " " + resp.connection.getResponseMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Create bucket on S3: STATUS = " + responseCode));
        }
    }

    public static void writeValue(String bucket, String awsAccessKey, String awsSecretAccessKey, String key, ValueData value) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        InputStream valueStream = value.isByteArray() ? new ByteArrayInputStream(value.getAsByteArray()) : value.getAsStream();
        Response resp = conn.put(bucket, key, new S3Object(valueStream, null), null);
        int responseCode = resp.connection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Failed PUT data to S3 storage. HTTP status " + responseCode);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Write to S3: STATUS = " + responseCode));
        }
    }

    public static boolean deleteValue(String bucket, String awsAccessKey, String awsSecretAccessKey, String key) throws IOException {
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        Response resp = conn.delete(bucket, key, null);
        int responseCode = resp.connection.getResponseCode();
        if (responseCode != 204) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Delete from S3: STATUS = " + responseCode));
        }
        return true;
    }

    public static String[] getBucketList(String bucket, String awsAccessKey, String awsSecretAccessKey, String prefix) throws IOException {
        List entries;
        AWSAuthConnection conn = new AWSAuthConnection(awsAccessKey, awsSecretAccessKey);
        ListBucketResponse resp = conn.listBucket(bucket, prefix, null, null, null);
        int responseCode = resp.connection.getResponseCode();
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Get list of bucket from S3: STATUS = " + responseCode));
        }
        if ((entries = resp.entries) != null) {
            String[] keys = new String[entries.size()];
            int i = 0;
            for (ListEntry l : entries) {
                keys[i] = l.key;
                ++i;
            }
            return keys;
        }
        return new String[0];
    }
}

