/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3ValueIOUtil;

public class S3File
extends File {
    protected final String awsAccessKey;
    protected final String awsSecretAccessKey;

    public S3File(String bucket, String awsAccessKey, String awsSecretAccessKey, String key) {
        super(bucket, key);
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
    }

    public boolean delete() {
        try {
            return S3ValueIOUtil.deleteValue(this.getParent(), this.awsAccessKey, this.awsSecretAccessKey, this.getName());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean exists() {
        try {
            return S3ValueIOUtil.isValueExists(this.getParent(), this.awsAccessKey, this.awsSecretAccessKey, this.getName());
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

