/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3File;
import org.exoplatform.services.jcr.aws.storage.value.s3.S3ValueIOUtil;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

public abstract class S3IOChannel
implements ValueIOChannel {
    protected static Log log = ExoLogger.getLogger((String)"S3IOChannel");
    protected final String bucket;
    protected final String awsAccessKey;
    protected final String awsSecretAccessKey;
    protected final File s3SwapDirectory;
    protected final FileCleaner cleaner;
    protected final String storageId;

    public S3IOChannel(String bucket, String awsAccessKey, String awsSecretAccessKey, File s3SwapDirectory, FileCleaner cleaner, String storageId) {
        this.bucket = bucket;
        this.awsAccessKey = awsAccessKey;
        this.awsSecretAccessKey = awsSecretAccessKey;
        this.s3SwapDirectory = s3SwapDirectory;
        this.cleaner = cleaner;
        this.storageId = storageId;
    }

    public boolean delete(String propertyId) throws IOException {
        String[] s3fileList;
        for (String s3fileName : s3fileList = this.getFiles(propertyId)) {
            if (S3ValueIOUtil.deleteValue(this.bucket, this.awsAccessKey, this.awsSecretAccessKey, s3fileName)) continue;
            log.warn((Object)("!!! Can't delete file " + s3fileName + "on Amazon S3 storage (Bucket: " + this.bucket + "). File added in FileCleaner list"));
            this.cleaner.addFile((File)new S3File(this.bucket, this.awsAccessKey, this.awsSecretAccessKey, s3fileName));
        }
        return true;
    }

    public void close() {
    }

    public ValueData read(String propertyId, int orderNumber, int maxBufferSize) throws IOException {
        String s3fileName = this.getFile(propertyId, orderNumber);
        return S3ValueIOUtil.readValue(this.bucket, this.awsAccessKey, this.awsSecretAccessKey, s3fileName, orderNumber, maxBufferSize, this.s3SwapDirectory, this.cleaner);
    }

    public void write(String propertyId, ValueData value) throws IOException {
        String s3fileName = this.getFile(propertyId, value.getOrderNumber());
        S3ValueIOUtil.writeValue(this.bucket, this.awsAccessKey, this.awsSecretAccessKey, s3fileName, value);
    }

    protected abstract String getFile(String var1, int var2);

    protected abstract String[] getFiles(String var1);

    public String getStorageId() {
        return this.storageId;
    }
}

