/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.sdb;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBWorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;

public class StorageCleaner
extends Thread {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.StorageCleaner");
    private volatile boolean run = true;
    private final int timeout;
    private final SDBWorkspaceStorageConnection sdbConn;

    StorageCleaner(String containerName, SDBWorkspaceStorageConnection sdbConn, int timeout) {
        this.setDaemon(true);
        this.setName("JCRSimpleDBStorageCleaner_" + containerName);
        this.sdbConn = sdbConn;
        this.timeout = timeout;
    }

    public void run() {
        while (this.run) {
            try {
                Random rnd = new Random();
                int rndPart = rnd.nextInt(this.timeout);
                Thread.sleep(this.timeout + rndPart);
            }
            catch (Throwable e) {
                LOG.error((Object)("Storage cleaner wait is interrupted " + e), e);
            }
            try {
                this.sdbConn.runCleanup();
            }
            catch (Throwable e) {
                LOG.error((Object)("Storage cleaner error " + e + ". Continue execution."), e);
            }
        }
    }

    public void cancel() {
        this.run = false;
    }
}

