/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.aws.storage.value.s3;

import java.io.IOException;

import org.exoplatform.services.jcr.storage.value.ValueIOChannel;

/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: SimpleS3ValueStorage.java 31570 2009-05-06 13:39:06Z pnedonosko $
 */
public class SimpleS3ValueStorage extends S3ValueStorage {

  /**
   * {@inheritDoc}
   */
  public ValueIOChannel openIOChannel() throws IOException {
    return new SimpleS3IOChannel(bucket,
                                 awsAccessKey,
                                 awsSecretAccessKey,
                                 s3SwapDirectory,
                                 cleaner,
                                 getId());
  }

}
