/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.ServerConfiguration;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.core.SharedDeviceList;
import org.exoplatform.services.log.ExoLogger;

public abstract class NetworkServer {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.server");
    private String version;
    private ServerConfiguration config;
    private boolean debug;
    private int debugFlags;
    private InetAddress[] ipAddr;
    private volatile boolean shutdown = false;
    private volatile boolean active = false;
    private Exception exception;
    private SharedDeviceList shares;

    public NetworkServer(ServerConfiguration config) {
        this.config = config;
        this.shares = new SharedDeviceList();
    }

    public final ServerConfiguration getConfiguration() {
        return this.config;
    }

    public final String getServerName() {
        return this.config.getServerName();
    }

    public final InetAddress[] getServerAddresses() {
        return this.ipAddr;
    }

    public SharedDeviceList getShares() {
        return this.shares;
    }

    public SharedDeviceList getAllShares(SrvSession sess) {
        SharedDeviceList shrList = new SharedDeviceList(this.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShares());
        }
        return shrList;
    }

    public final SharedDevice findShare(String name, int typ, SrvSession sess) throws Exception {
        SharedDevice share = null;
        if (sess.hasDynamicShares()) {
            share = sess.getDynamicShares().findShare(name, typ, true);
        }
        if (share == null && (share = this.getShares().findShare(name, typ, false)) == null) {
            share = this.getShares().findShare(name, typ, true);
        }
        return share;
    }

    public final boolean isActive() {
        return this.active;
    }

    public final String isVersion() {
        return this.version;
    }

    public final boolean hasException() {
        return this.exception != null;
    }

    public final Exception getException() {
        return this.exception;
    }

    public final void clearException() {
        this.exception = null;
    }

    public final boolean hasDebug() {
        return this.debug;
    }

    public final boolean hasDebugFlag(int flag) {
        return (this.debugFlags & flag) != 0;
    }

    public final boolean hasShutdown() {
        return this.shutdown;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected final void setException(Exception ex) {
        this.exception = ex;
    }

    protected final void setServerAddresses(InetAddress[] addrs) {
        this.ipAddr = addrs;
    }

    protected final void setVersion(String ver) {
        this.version = ver;
    }

    protected final void setDebug(boolean dbg) {
        this.debug = dbg;
    }

    protected final void setDebugFlags(int flags) {
        this.debugFlags = flags;
        this.setDebug(flags != 0);
    }

    protected final void setShutdown(boolean value) {
        this.shutdown = value;
    }

    public abstract void startServer();

    public abstract void shutdownServer(boolean var1);
}

