/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.filesys;

import javax.jcr.Session;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.filesys.FileAccess;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.TooManyFilesException;

public class TreeConnection {
    public static final int MAXFILES = 8192;
    public static final int INITIALFILES = 32;
    private SharedDevice m_shareDev;
    private Session m_jcr_sess;
    private NetworkFile[] m_files;
    private int m_fileCount;
    private int m_permission;

    public TreeConnection(SharedDevice shrDev) {
        this.m_shareDev = shrDev;
    }

    public void setSession(Session sess) {
        this.m_jcr_sess = sess;
    }

    public Session getSession() {
        return this.m_jcr_sess;
    }

    public boolean hasSession() {
        return false;
    }

    public final int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        int idx;
        if (this.m_files == null) {
            this.m_files = new NetworkFile[32];
        }
        for (idx = 0; idx < this.m_files.length && this.m_files[idx] != null; ++idx) {
        }
        if (idx == this.m_files.length) {
            if (this.isMaxFilesAchieved()) {
                throw new TooManyFilesException();
            }
            NetworkFile[] newFiles = new NetworkFile[this.m_files.length * 2];
            System.arraycopy(this.m_files, 0, newFiles, 0, this.m_files.length);
            this.m_files = newFiles;
        }
        this.m_files[idx] = file;
        ++this.m_fileCount;
        return idx;
    }

    public final boolean isMaxFilesAchieved() {
        return this.m_files.length >= 8192;
    }

    public final void closeConnection(SrvSession sess) {
        if (this.openFileCount() > 0) {
            for (int idx = 0; idx < this.m_files.length; ++idx) {
                if (this.m_files[idx] == null) continue;
                this.removeFile(idx, sess);
            }
        }
        this.m_shareDev.decrementConnectionCount();
    }

    public final NetworkFile findFile(int fid) {
        if (this.m_files == null || fid >= this.m_files.length) {
            return null;
        }
        return this.m_files[fid];
    }

    public final int getFileTableLength() {
        if (this.m_files == null) {
            return 0;
        }
        return this.m_files.length;
    }

    public final int getPermission() {
        return this.m_permission;
    }

    public final boolean hasReadAccess() {
        return this.m_permission == 1 || this.m_permission == 2;
    }

    public final boolean hasWriteAccess() {
        return this.m_permission == 2;
    }

    public final SharedDevice getSharedDevice() {
        return this.m_shareDev;
    }

    public final boolean hasPermission(int perm) {
        return this.m_permission >= perm;
    }

    public final int openFileCount() {
        return this.m_fileCount;
    }

    public final void removeAllFiles() {
        if (this.m_files == null) {
            return;
        }
        int idx = 0;
        while (idx < this.m_files.length) {
            this.m_files[idx++] = null;
        }
        this.m_fileCount = 0;
    }

    public final void removeFile(int idx, SrvSession sess) {
        if (this.m_files == null || idx >= this.m_files.length) {
            return;
        }
        this.m_files[idx] = null;
        --this.m_fileCount;
    }

    public final void setPermission(int perm) {
        this.m_permission = perm;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_shareDev.toString());
        str.append(",");
        str.append(this.m_fileCount);
        str.append(":");
        str.append(FileAccess.asString(this.m_permission));
        str.append("]");
        return str.toString();
    }
}

