/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.dcerpc.server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.core.SharedDeviceList;
import org.exoplatform.services.cifs.smb.dcerpc.DCEBuffer;
import org.exoplatform.services.cifs.smb.dcerpc.DCEBufferException;
import org.exoplatform.services.cifs.smb.dcerpc.Srvsvc;
import org.exoplatform.services.cifs.smb.dcerpc.info.ServerInfo;
import org.exoplatform.services.cifs.smb.dcerpc.info.ShareInfo;
import org.exoplatform.services.cifs.smb.dcerpc.info.ShareInfoList;
import org.exoplatform.services.cifs.smb.dcerpc.server.DCEHandler;
import org.exoplatform.services.cifs.smb.dcerpc.server.DCEPipeFile;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;

public class SrvsvcDCEHandler
implements DCEHandler {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");

    public void processRequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile) throws IOException, SMBSrvException {
        int opNum = inBuf.getHeaderValue(9);
        try {
            inBuf.skipBytes(24);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("DCE/RPC SrvSvc request=" + Srvsvc.getOpcodeName(opNum)));
        }
        DCEBuffer outBuf = new DCEBuffer();
        outBuf.putResponseHeader(inBuf.getHeaderValue(7), 0);
        boolean processed = false;
        switch (opNum) {
            case 15: {
                processed = this.netShareEnum(sess, inBuf, outBuf);
                break;
            }
            case 36: {
                processed = this.netShareEnum(sess, inBuf, outBuf);
                break;
            }
            case 16: {
                processed = this.netShareGetInfo(sess, inBuf, outBuf);
                break;
            }
            case 21: {
                processed = this.netServerGetInfo(sess, inBuf, outBuf);
                break;
            }
        }
        if (!processed) {
            sess.sendErrorResponseSMB(65535, 2);
            return;
        }
        outBuf.setHeaderValue(8, outBuf.getLength());
        pipeFile.setBufferedData(outBuf);
    }

    protected final boolean netShareEnum(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        ShareInfoList shrInfo = null;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            shrInfo = new ShareInfoList(inBuf);
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("NetShareEnum srvName=" + srvName + ", shrInfo=" + shrInfo.toString()));
        }
        SharedDeviceList shareList = sess.getServer().getAllShares(sess);
        Vector<ShareInfo> infoList = new Vector<ShareInfo>();
        Enumeration<SharedDevice> enm = shareList.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice share = enm.nextElement();
            int shrTyp = 0;
            if (share.getType() == 1) {
                shrTyp = 1;
            } else if (share.getType() == 2) {
                shrTyp = 3;
            } else if (share.getType() == 3) {
                shrTyp = -2147483645;
            }
            ShareInfo info = new ShareInfo(shrInfo.getInformationLevel(), share.getName(), shrTyp, share.getComments());
            infoList.add(info);
            switch (shrInfo.getInformationLevel()) {
                case 2: {
                    break;
                }
            }
        }
        shrInfo.setShareList(infoList);
        try {
            shrInfo.writeList(outBuf);
            outBuf.putInt(0);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return true;
    }

    protected final boolean netShareGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        String shrName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            shrName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("netShareGetInfo srvname=" + srvName + ", share=" + shrName + ", infoLevel=" + infoLevel));
        }
        SharedDevice share = null;
        try {
            share = sess.getServer().findShare(shrName, -1, sess);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (share == null) {
            return false;
        }
        int shrTyp = 0;
        if (share.getType() == 1) {
            shrTyp = 1;
        } else if (share.getType() == 2) {
            shrTyp = 3;
        } else if (share.getType() == 3) {
            shrTyp = -2147483645;
        }
        ShareInfo shrInfo = new ShareInfo(infoLevel, share.getName(), shrTyp, share.getComments());
        outBuf.putInt(infoLevel);
        outBuf.putPointer(true);
        shrInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }

    protected final boolean netServerGetInfo(SMBSrvSession sess, DCEBuffer inBuf, DCEBuffer outBuf) {
        String srvName = null;
        int infoLevel = 0;
        try {
            inBuf.skipPointer();
            srvName = inBuf.getString(1);
            infoLevel = inBuf.getInt();
        }
        catch (DCEBufferException ex) {
            return false;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(16384)) {
            logger.debug((Object)("netServerGetInfo srvname=" + srvName + ", infoLevel=" + infoLevel));
        }
        ServerInfo srvInfo = new ServerInfo(infoLevel);
        SMBServer srv = sess.getSMBServer();
        srvInfo.setServerName(srv.getServerName());
        srvInfo.setComment(srv.getComment());
        srvInfo.setServerType(srv.getServerType());
        srvInfo.setPlatformId(500);
        srvInfo.setVersion(5, 1);
        srvInfo.writeObject(outBuf, outBuf);
        outBuf.putInt(0);
        return true;
    }
}

