/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.mailslot;

import org.exoplatform.services.cifs.netbios.NetBIOSName;
import org.exoplatform.services.cifs.netbios.win32.NetBIOS;
import org.exoplatform.services.cifs.netbios.win32.Win32NetBIOS;
import org.exoplatform.services.cifs.smb.mailslot.HostAnnouncer;
import org.exoplatform.services.cifs.smb.server.win32.Win32NetBIOSSessionSocketHandler;

public class Win32NetBIOSHostAnnouncer
extends HostAnnouncer {
    private static final int SendErrorCount = 3;
    Win32NetBIOSSessionSocketHandler m_handler;

    public Win32NetBIOSHostAnnouncer(Win32NetBIOSSessionSocketHandler handler, String domain, int intval) {
        this.m_handler = handler;
        this.addHostName(handler.getServerName());
        this.setDomain(domain);
        this.setInterval(intval);
    }

    public final int getLana() {
        return this.m_handler.getLANANumber();
    }

    public final int getNameNumber() {
        return this.m_handler.getNameNumber();
    }

    protected void initialize() throws Exception {
        this.setName("Win32HostAnnouncer_L" + this.getLana());
    }

    public boolean isNetworkEnabled() {
        return this.m_handler.isLANAValid();
    }

    protected void sendAnnouncement(String hostName, byte[] buf, int offset, int len) throws Exception {
        NetBIOSName destNbName = new NetBIOSName(this.getDomain(), '\u001d', false);
        byte[] destName = destNbName.getNetBIOSName();
        int sts = Win32NetBIOS.SendDatagram(this.getLana(), this.getNameNumber(), destName, buf, 0, len);
        if (sts != 0) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Host announce error " + NetBIOS.getErrorString(-sts) + " (LANA " + this.getLana() + ")"));
            }
            if (this.incrementErrorCount() == 3) {
                this.m_handler.lanaStatusChange(this.getLana(), false);
                this.clearErrorCount();
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Marked LANA as unavailable due to send errors");
                }
            }
        } else {
            this.clearErrorCount();
        }
    }
}

