/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.mailslot;

import java.io.IOException;
import org.exoplatform.services.cifs.netbios.NetBIOSName;
import org.exoplatform.services.cifs.netbios.win32.NetBIOSSocket;
import org.exoplatform.services.cifs.smb.mailslot.HostAnnouncer;
import org.exoplatform.services.cifs.smb.server.win32.Win32NetBIOSSessionSocketHandler;

public class WinsockNetBIOSHostAnnouncer
extends HostAnnouncer {
    private static final int SendErrorCount = 3;
    private Win32NetBIOSSessionSocketHandler m_handler;
    private NetBIOSSocket m_dgramSocket;

    public WinsockNetBIOSHostAnnouncer(Win32NetBIOSSessionSocketHandler handler, String domain, int intval) {
        this.m_handler = handler;
        this.addHostName(handler.getServerName());
        this.setDomain(domain);
        this.setInterval(intval);
    }

    public final int getLana() {
        return this.m_handler.getLANANumber();
    }

    protected void initialize() throws Exception {
        this.setName("WinsockHostAnnouncer_L" + this.getLana());
        this.m_dgramSocket = NetBIOSSocket.createDatagramSocket(this.getLana());
    }

    public boolean isNetworkEnabled() {
        return this.m_handler.isLANAValid();
    }

    protected void sendAnnouncement(String hostName, byte[] buf, int offset, int len) throws Exception {
        boolean txOK;
        block7: {
            NetBIOSName destNbName = new NetBIOSName(this.getDomain(), '\u001d', false);
            txOK = false;
            try {
                int sts = this.m_dgramSocket.sendDatagram(destNbName, buf, 0, len);
                if (sts == len) {
                    txOK = true;
                }
            }
            catch (IOException ex) {
                if (!logger.isErrorEnabled()) break block7;
                logger.error((Object)("Host announce error, " + ex.getMessage() + ", (LANA " + this.getLana() + ")"));
            }
        }
        if (!txOK) {
            if (this.incrementErrorCount() == 3) {
                this.m_handler.lanaStatusChange(this.getLana(), false);
                this.clearErrorCount();
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Marked LANA as unavailable due to send errors, (LANA " + this.getLana() + ")"));
                }
            }
        } else {
            this.clearErrorCount();
        }
    }
}

