/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.IOException;
import org.exoplatform.services.cifs.smb.TransactBuffer;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SMBTransPacket;
import org.exoplatform.services.cifs.util.DataBuffer;
import org.exoplatform.services.cifs.util.DataPacker;

class SMBSrvTransPacket
extends SMBTransPacket {
    private static final int StandardParamsResponse = 10;
    protected static final int SetupOffsetResponse = 57;

    public SMBSrvTransPacket(byte[] buf) {
        super(buf);
    }

    public SMBSrvTransPacket(int siz) {
        super(siz);
        this.setMultiplexId(SMBSrvTransPacket.getNextMultiplexId());
    }

    public static final void initTransactReply(SMBSrvPacket pkt, int prmCnt, int prmPos, int dataCnt, int dataPos) {
        pkt.setParameterCount(10);
        pkt.setParameter(0, prmCnt);
        pkt.setParameter(1, dataCnt);
        pkt.setParameter(2, 0);
        pkt.setParameter(3, prmCnt);
        pkt.setParameter(4, prmPos - 4);
        pkt.setParameter(5, 0);
        pkt.setParameter(6, dataCnt);
        pkt.setParameter(7, dataPos - 4);
        pkt.setParameter(8, 0);
        pkt.setParameter(9, 0);
    }

    protected static final int CalculateDataItemSize(String desc) {
        int len = 0;
        int pos = 0;
        while (pos < desc.length()) {
            char dtype = desc.charAt(pos++);
            int dlen = 1;
            if (pos < desc.length() && Character.isDigit(desc.charAt(pos))) {
                int numlen = 1;
                int numpos = pos + 1;
                while (numpos < desc.length() && Character.isDigit(desc.charAt(numpos++))) {
                    ++numlen;
                }
                dlen = Integer.parseInt(desc.substring(pos, pos + numlen));
                pos = numpos - 1;
            }
            switch (dtype) {
                case 'W': {
                    len += 2;
                    break;
                }
                case 'D': {
                    len += 4;
                    break;
                }
                case 'B': {
                    len += dlen;
                    break;
                }
                case 'z': {
                    len += 4;
                    break;
                }
                case '.': {
                    len += dlen;
                    break;
                }
                case 'T': {
                    len += 4;
                }
            }
        }
        return len;
    }

    public final int getDataBlockOffset(int prmLen) {
        int pos = this.getParameterBlockOffset() + prmLen;
        if ((pos & 1) != 0) {
            ++pos;
        }
        return pos;
    }

    public final int getRxDataBlock() {
        return this.getParameter(12) + 4;
    }

    public final int getRxDataBlockLength() {
        return this.getParameter(11);
    }

    public final int getRxParameter(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelShort(this.getBuffer(), pos += prmIdx * 2);
    }

    public final int getRxParameterBlock() {
        return this.getParameter(10) + 4;
    }

    public final int getRxParameterBlockLength() {
        return this.getParameter(9);
    }

    public final int getRxParameterCount() {
        return this.getParameterCount() - 14;
    }

    public final int getRxParameterInt(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelInt(this.getBuffer(), pos += prmIdx * 2);
    }

    public final String getRxParameterString(int pos, boolean uni) {
        pos += this.getRxParameterBlock();
        byte[] buf = this.getBuffer();
        int len = buf[pos++] & 0xFF;
        return DataPacker.getString(buf, pos, len, uni);
    }

    public final String getRxParameterString(int pos, int len, boolean uni) {
        byte[] buf = this.getBuffer();
        return DataPacker.getString(buf, pos += this.getRxParameterBlock(), len, uni);
    }

    public final String getRxTransactName() {
        if (this.getCommand() == 50) {
            return "";
        }
        int pos = this.getByteOffset();
        return DataPacker.getString(this.getBuffer(), pos, this.getByteCount());
    }

    public final int getSetupCount() {
        return this.getParameter(13) & 0xFF;
    }

    public final int getSetupOffset() {
        return 65;
    }

    public final int getSetupParameter(int idx) {
        if (idx >= this.getRxParameterCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getParameter(idx + 14);
    }

    public final int getMaximumReturnParameterCount() {
        return this.getParameter(2);
    }

    public final int getMaximumReturnDataCount() {
        return this.getParameter(3);
    }

    public final int getMaximumReturnSetupCount() {
        return this.getParameter(4);
    }

    public final int getSetupParameterInt(int idx) {
        if (idx >= this.getRxParameterCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getParameterLong(idx + 14);
    }

    public final void setTotalParameterCount(int cnt) {
        this.setParameter(0, cnt);
    }

    public final void setTotalDataCount(int cnt) {
        this.setParameter(1, cnt);
    }

    public final void setParameterBlockCount(int len) {
        this.setParameter(3, len);
    }

    public final void setParameterBlockOffset(int off) {
        this.setParameter(4, off != 0 ? off - 4 : 0);
    }

    public final void setParameterBlockDisplacement(int disp) {
        this.setParameter(5, disp);
    }

    public final void setDataBlockCount(int len) {
        this.setParameter(6, len);
    }

    public final void setDataBlockOffset(int off) {
        this.setParameter(7, off != 0 ? off - 4 : 0);
    }

    public final void setDataBlockDisplacement(int disp) {
        this.setParameter(8, disp);
    }

    protected final void doTransactionResponse(SMBSrvSession sess, TransactBuffer tbuf) throws IOException {
        int dlen;
        int plen;
        this.setCommand(tbuf.isType());
        tbuf.setEndOfBuffer();
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        DataBuffer dataBuf = tbuf.getDataBuffer();
        if (tbuf.hasSetupBuffer()) {
            this.setParameterCount(10 + setupBuf.getLengthInWords());
        } else {
            this.setParameterCount(10);
        }
        for (int i = 0; i < this.getParameterCount(); ++i) {
            this.setParameter(i, 0);
        }
        int totParamLen = paramBuf != null ? paramBuf.getLength() : 0;
        int totDataLen = dataBuf != null ? dataBuf.getLength() : 0;
        this.setTotalParameterCount(totParamLen);
        this.setTotalDataCount(totDataLen);
        int availBuf = this.getAvailableLength();
        int clientLen = this.getAvailableLength(sess.getClientMaximumBufferSize());
        if (availBuf > clientLen) {
            availBuf = clientLen;
        }
        if ((plen = totParamLen) + (dlen = totDataLen) > availBuf) {
            if (plen > 0) {
                if (plen <= availBuf) {
                    if (dlen > 0) {
                        dlen = availBuf - plen;
                    }
                } else {
                    dlen = plen = availBuf / 2;
                }
            } else if (dlen > availBuf) {
                dlen = availBuf;
            }
        }
        this.setParameterBlockCount(plen);
        this.setDataBlockCount(dlen);
        if (setupBuf != null) {
            setupBuf.copyData(this.getBuffer(), 57);
        }
        int pos = DataPacker.wordAlign(this.getByteOffset());
        this.setPosition(pos);
        this.setParameterBlockCount(plen);
        this.setParameterBlockOffset(pos);
        int packLen = -1;
        if (paramBuf != null) {
            packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
            pos = DataPacker.longwordAlign(pos + packLen);
            this.setPosition(pos);
        }
        this.setDataBlockCount(dlen);
        this.setDataBlockOffset(pos);
        if (dataBuf != null) {
            packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
            this.setPosition(pos + packLen);
        }
        this.setByteCount();
        sess.sendResponseSMB(this);
        availBuf = this.getAvailableLength();
        if (availBuf > clientLen) {
            availBuf = clientLen;
        }
        Object rxBuf = null;
        while (paramBuf != null && paramBuf.getAvailableLength() > 0 || dataBuf != null && dataBuf.getAvailableLength() > 0) {
            this.setCommand(tbuf.isType());
            plen = paramBuf != null ? paramBuf.getAvailableLength() : 0;
            int n = dlen = dataBuf != null ? dataBuf.getAvailableLength() : 0;
            if (plen + dlen > availBuf) {
                if (plen > 0) {
                    if (plen <= availBuf) {
                        if (dlen > 0) {
                            dlen = availBuf - plen;
                        }
                    } else {
                        dlen = plen = availBuf / 2;
                    }
                } else if (dlen > availBuf) {
                    dlen = availBuf;
                }
            }
            this.resetBytePointerAlign();
            packLen = -1;
            pos = this.getPosition();
            if (plen > 0 && paramBuf != null) {
                this.setParameterBlockOffset(pos);
                this.setParameterBlockCount(plen);
                this.setParameterBlockDisplacement(paramBuf.getDisplacement());
                packLen = paramBuf.copyData(this.getBuffer(), pos, plen);
                pos = DataPacker.wordAlign(pos + packLen);
                this.setPosition(pos);
            } else {
                this.setParameterBlockCount(0);
                this.setParameterBlockOffset(pos);
            }
            if (dlen > 0 && dataBuf != null) {
                this.setDataBlockOffset(pos);
                this.setDataBlockCount(dlen);
                this.setDataBlockDisplacement(dataBuf.getDisplacement());
                packLen = dataBuf.copyData(this.getBuffer(), pos, dlen);
                this.setPosition(pos + packLen);
            } else {
                this.setDataBlockCount(0);
                this.setDataBlockOffset(pos);
            }
            this.setByteCount();
            sess.sendResponseSMB(this);
        }
    }
}

