/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.util.DataPacker;

public class SMBTransPacket
extends SMBSrvPacket {
    protected static final int STD_PARAMS = 14;
    public static final int IsContinued = 234;
    protected String m_transName;
    protected int m_paramCnt;
    private static int m_nextMID = 1;

    public SMBTransPacket(byte[] buf) {
        super(buf);
    }

    public SMBTransPacket(int siz) {
        super(siz);
        this.setMultiplexId(SMBTransPacket.getNextMultiplexId());
    }

    public static final int getNextMultiplexId() {
        return m_nextMID++;
    }

    public final int getTotalParameterCount() {
        return this.getParameter(0);
    }

    public final int getTotalDataCount() {
        return this.getParameter(1);
    }

    public final int getParameterBlockCount() {
        return this.getParameter(9);
    }

    public final int getParameterBlockOffset() {
        return this.getParameter(10) + 4;
    }

    public final int getDataBlockCount() {
        return this.getParameter(11);
    }

    public final int getDataBlockOffset() {
        return this.getParameter(12) + 4;
    }

    public final int getSecondaryParameterBlockCount() {
        return this.getParameter(2);
    }

    public final int getSecondaryParameterBlockOffset() {
        return this.getParameter(3) + 4;
    }

    public final int getParameterBlockDisplacement() {
        return this.getParameter(4);
    }

    public final int getSecondaryDataBlockCount() {
        return this.getParameter(5);
    }

    public final int getSecondaryDataBlockOffset() {
        return this.getParameter(6) + 4;
    }

    public final int getDataBlockDisplacement() {
        return this.getParameter(7);
    }

    public final int getSubFunction() {
        return this.getParameter(14);
    }

    public final void getParameterBlock(short[] prmblk) throws ArrayIndexOutOfBoundsException {
        int prmcnt = this.getParameter(3) / 2;
        if (prmblk.length < prmcnt) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int pos = this.getParameter(4) + 4;
        byte[] buf = this.getBuffer();
        for (int idx = 0; idx < prmcnt; ++idx) {
            prmblk[idx] = (short)DataPacker.getIntelShort(buf, pos);
            pos += 2;
        }
    }

    public final void InitializeTransact(int pcnt, byte[] paramblk, int plen, byte[] datablk, int dlen) {
        int idx;
        int pos;
        if (this.m_transName == null) {
            this.setCommand(50);
        } else {
            this.setCommand(37);
        }
        this.setParameterCount(pcnt);
        this.m_paramCnt = pcnt;
        this.setParameter(0, plen);
        this.setParameter(1, dlen);
        int i = 2;
        while (i < 9) {
            this.setParameter(i++, 0);
        }
        this.setParameter(9, plen);
        this.setParameter(11, dlen);
        this.setParameter(13, pcnt - 14);
        int startPos = pos = this.getByteOffset();
        byte[] buf = this.getBuffer();
        if (this.m_transName != null) {
            byte[] nam = this.m_transName.getBytes();
            for (idx = 0; idx < nam.length; ++idx) {
                buf[pos++] = nam[idx];
            }
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (paramblk != null) {
            this.setParameter(10, pos - 4);
            for (idx = 0; idx < plen; ++idx) {
                buf[pos++] = paramblk[idx];
            }
        } else {
            this.setParameter(10, 0);
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (datablk != null) {
            this.setParameter(12, pos - 4);
            for (idx = 0; idx < dlen; ++idx) {
                buf[pos++] = datablk[idx];
            }
        } else {
            this.setParameter(12, 0);
        }
        this.setByteCount(pos - startPos);
    }

    public final void setSetupParameter(int idx, int val) {
        this.setParameter(14 + idx, val);
    }

    public final void setTransactionName(String tname) {
        this.m_transName = tname;
    }
}

