/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.cifs.smb.server.SMBServer;

public abstract class SessionSocketHandler
implements Runnable {
    protected static Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    protected static final int LISTEN_BACKLOG = 10;
    private SMBServer m_server;
    private int m_port;
    private InetAddress m_bindAddr;
    private ServerSocket m_srvSock;
    private boolean m_debug;
    private boolean m_shutdown;
    private String m_name;
    private static int m_sessId;

    public SessionSocketHandler(String name, SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        this.m_name = name;
        this.m_server = srv;
        this.m_port = port;
        this.m_bindAddr = bindAddr;
        this.m_debug = debug;
    }

    public SessionSocketHandler(String name, SMBServer srv, boolean debug) {
        this.m_name = name;
        this.m_server = srv;
        this.m_debug = debug;
    }

    public final String getName() {
        return this.m_name;
    }

    protected final SMBServer getServer() {
        return this.m_server;
    }

    protected final int getPort() {
        return this.m_port;
    }

    protected final boolean hasBindAddress() {
        return this.m_bindAddr != null;
    }

    protected final InetAddress getBindAddress() {
        return this.m_bindAddr;
    }

    protected final synchronized int getNextSessionId() {
        return m_sessId++;
    }

    protected final boolean hasDebug() {
        return this.m_debug;
    }

    protected final ServerSocket getSocket() {
        return this.m_srvSock;
    }

    protected final void setSocket(ServerSocket sock) {
        this.m_srvSock = sock;
    }

    protected final boolean hasShutdown() {
        return this.m_shutdown;
    }

    protected final void clearShutdown() {
        this.m_shutdown = false;
    }

    public void shutdownRequest() {
        this.m_shutdown = true;
        try {
            if (this.m_srvSock != null) {
                this.m_srvSock.close();
            }
        }
        catch (SocketException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize() throws Exception {
        ServerSocket srvSock = null;
        srvSock = this.hasBindAddress() ? new ServerSocket(this.getPort(), 10, this.getBindAddress()) : new ServerSocket(this.getPort(), 10);
        this.setSocket(srvSock);
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)("Binding " + this.getName() + " session handler to local address : " + (this.hasBindAddress() ? this.getBindAddress().getHostAddress() : "ALL")));
        }
    }

    public abstract void run();

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(this.getServer().getServerName());
        str.append(",");
        str.append(this.getBindAddress() != null ? this.getBindAddress().getHostAddress() : "<All>");
        str.append(":");
        str.append(this.getPort());
        str.append("]");
        return str.toString();
    }
}

