/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.util;

import org.exoplatform.services.cifs.util.DataPacker;

public class DataBuffer {
    private static final int DefaultBufferSize = 256;
    private byte[] m_data;
    private int m_pos;
    private int m_endpos;
    private int m_offset;

    public DataBuffer() {
        this.m_data = new byte[256];
        this.m_pos = 0;
        this.m_offset = 0;
    }

    public DataBuffer(int siz) {
        this.m_data = new byte[siz];
        this.m_pos = 0;
        this.m_offset = 0;
    }

    public DataBuffer(byte[] buf, int off, int len) {
        this.m_data = buf;
        this.m_offset = off;
        this.m_pos = off;
        this.m_endpos = off + len;
    }

    public final byte[] getBuffer() {
        return this.m_data;
    }

    public final int getLength() {
        if (this.m_endpos != 0) {
            return this.m_endpos - this.m_offset;
        }
        return this.m_pos - this.m_offset;
    }

    public final int getLengthInWords() {
        return this.getLength() / 2;
    }

    public final int getAvailableLength() {
        if (this.m_endpos == 0) {
            return -1;
        }
        return this.m_endpos - this.m_pos;
    }

    public final int getDisplacement() {
        return this.m_pos - this.m_offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final int getByte() {
        if (this.m_data.length - this.m_pos < 1) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int bval = this.m_data[this.m_pos] & 0xFF;
        ++this.m_pos;
        return bval;
    }

    public final int getShort() {
        if (this.m_data.length - this.m_pos < 2) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int sval = DataPacker.getIntelShort(this.m_data, this.m_pos);
        this.m_pos += 2;
        return sval;
    }

    public final int getInt() {
        if (this.m_data.length - this.m_pos < 4) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int ival = DataPacker.getIntelInt(this.m_data, this.m_pos);
        this.m_pos += 4;
        return ival;
    }

    public final long getLong() {
        if (this.m_data.length - this.m_pos < 8) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        long lval = DataPacker.getIntelLong(this.m_data, this.m_pos);
        this.m_pos += 8;
        return lval;
    }

    public final String getString(boolean uni) {
        return this.getString(255, uni);
    }

    public final String getString(int maxlen, boolean uni) {
        String ret = null;
        int availLen = -1;
        if (uni) {
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            availLen = (this.m_endpos - this.m_pos) / 2;
            if (availLen < maxlen) {
                maxlen = availLen;
            }
            if ((ret = DataPacker.getUnicodeString(this.m_data, this.m_pos, maxlen)) != null) {
                this.m_pos = ret.length() < maxlen ? (this.m_pos += ret.length() * 2 + 2) : (this.m_pos += maxlen * 2);
            }
        } else {
            availLen = this.m_endpos - this.m_pos;
            if (availLen < maxlen) {
                maxlen = availLen;
            }
            if ((ret = DataPacker.getString(this.m_data, this.m_pos, maxlen)) != null) {
                this.m_pos = ret.length() < maxlen ? (this.m_pos += ret.length() + 1) : (this.m_pos += maxlen);
            }
        }
        return ret;
    }

    public final int getShortAt(int idx) {
        int pos = this.m_offset + idx * 2;
        if (this.m_data.length - pos < 2) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int sval = DataPacker.getIntelShort(this.m_data, pos) & 0xFFFF;
        return sval;
    }

    public final int getIntAt(int idx) {
        int pos = this.m_offset + idx * 2;
        if (this.m_data.length - pos < 4) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int ival = DataPacker.getIntelInt(this.m_data, pos);
        return ival;
    }

    public final long getLongAt(int idx) {
        int pos = this.m_offset + idx * 2;
        if (this.m_data.length - pos < 8) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        long lval = DataPacker.getIntelLong(this.m_data, pos);
        return lval;
    }

    public final void skipBytes(int cnt) {
        if (this.m_data.length - this.m_pos < cnt) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        this.m_pos += cnt;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final void setPosition(int pos) {
        this.m_pos = pos;
    }

    public final void setEndOfBuffer() {
        this.m_endpos = this.m_pos;
        this.m_pos = this.m_offset;
    }

    public final void setLength(int len) {
        this.m_pos = this.m_offset + len;
    }

    public final void putByte(int bval) {
        if (this.m_data.length - this.m_pos < 1) {
            this.extendBuffer();
        }
        this.m_data[this.m_pos++] = (byte)(bval & 0xFF);
    }

    public final void putShort(int sval) {
        if (this.m_data.length - this.m_pos < 2) {
            this.extendBuffer();
        }
        DataPacker.putIntelShort(sval, this.m_data, this.m_pos);
        this.m_pos += 2;
    }

    public final void putInt(int ival) {
        if (this.m_data.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(ival, this.m_data, this.m_pos);
        this.m_pos += 4;
    }

    public final void putLong(long lval) {
        if (this.m_data.length - this.m_pos < 8) {
            this.extendBuffer();
        }
        DataPacker.putIntelLong(lval, this.m_data, this.m_pos);
        this.m_pos += 8;
    }

    public final void putShortAt(int idx, int sval) {
        int pos = this.m_offset + idx * 2;
        if (this.m_data.length - pos < 2) {
            this.extendBuffer();
        }
        DataPacker.putIntelShort(sval, this.m_data, pos);
    }

    public final void putIntAt(int idx, int ival) {
        this.m_offset = idx * 2;
        int pos = this.m_offset;
        if (this.m_data.length - pos < 4) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(ival, this.m_data, pos);
    }

    public final void putLongAt(int idx, int lval) {
        this.m_offset = idx * 2;
        int pos = this.m_offset;
        if (this.m_data.length - pos < 8) {
            this.extendBuffer();
        }
        DataPacker.putIntelLong(lval, this.m_data, pos);
    }

    public final void putString(String str, boolean uni) {
        this.putString(str, uni, true);
    }

    public final void putString(String str, boolean uni, boolean nulTerm) {
        if (uni) {
            int bytLen = str.length() * 2;
            if (nulTerm) {
                bytLen += 2;
            }
            if (this.m_data.length - this.m_pos < bytLen + 4) {
                this.extendBuffer(bytLen + 4);
            }
            this.m_pos = DataPacker.wordAlign(this.m_pos);
            DataPacker.putUnicodeString(str, this.m_data, this.m_pos, nulTerm);
            this.m_pos += str.length() * 2;
            if (nulTerm) {
                this.m_pos += 2;
            }
        } else {
            if (this.m_data.length - this.m_pos < str.length()) {
                this.extendBuffer(str.length() + 2);
            }
            DataPacker.putString(str, this.m_data, this.m_pos, nulTerm);
            this.m_pos += str.length();
            if (nulTerm) {
                ++this.m_pos;
            }
        }
    }

    public final void putFixedString(String str, int len) {
        if (this.m_data.length - this.m_pos < str.length()) {
            this.extendBuffer(str.length() + 2);
        }
        DataPacker.putString(str, len, this.m_data, this.m_pos);
        this.m_pos += len;
    }

    public final int putStringAt(String str, int pos, boolean uni, boolean nulTerm) {
        int retPos = -1;
        if (uni) {
            int bytLen = str.length() * 2;
            if (this.m_data.length - pos < bytLen) {
                this.extendBuffer(bytLen + 4);
            }
            pos = DataPacker.wordAlign(pos);
            retPos = DataPacker.putUnicodeString(str, this.m_data, pos, nulTerm);
        } else {
            if (this.m_data.length - pos < str.length()) {
                this.extendBuffer(str.length() + 2);
            }
            retPos = DataPacker.putString(str, this.m_data, pos, nulTerm);
        }
        return retPos;
    }

    public final int putFixedStringAt(String str, int len, int pos) {
        if (this.m_data.length - pos < str.length()) {
            this.extendBuffer(str.length() + 2);
        }
        return DataPacker.putString(str, len, this.m_data, pos);
    }

    public final void putStringPointer(int off) {
        DataPacker.putIntelInt(off - this.m_offset, this.m_data, this.m_pos);
        this.m_pos += 4;
    }

    public final void putZeros(int cnt) {
        if (this.m_data.length - this.m_pos < cnt) {
            this.extendBuffer(cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            this.m_data[this.m_pos++] = 0;
        }
    }

    public final void wordAlign() {
        this.m_pos = DataPacker.wordAlign(this.m_pos);
    }

    public final void longwordAlign() {
        this.m_pos = DataPacker.longwordAlign(this.m_pos);
    }

    public final void appendData(byte[] buf, int off, int len) {
        if (this.m_data.length - this.m_pos < len) {
            this.extendBuffer(len);
        }
        System.arraycopy(buf, off, this.m_data, this.m_pos, len);
        this.m_pos += len;
    }

    public final int copyData(byte[] buf, int off) {
        return this.copyData(buf, off, this.getLength());
    }

    public final int copyData(byte[] buf, int off, int cnt) {
        if (this.m_pos == this.m_endpos) {
            return 0;
        }
        int siz = this.m_endpos - this.m_pos;
        if (siz > cnt) {
            siz = cnt;
        }
        System.arraycopy(this.m_data, this.m_pos, buf, off, siz);
        this.m_pos += siz;
        return siz;
    }

    private final void extendBuffer(int ext) {
        byte[] newBuf = new byte[this.m_data.length + ext];
        System.arraycopy(this.m_data, 0, newBuf, 0, this.m_data.length);
        this.m_data = newBuf;
    }

    private final void extendBuffer() {
        this.extendBuffer(this.m_data.length * 2);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[data=");
        str.append(this.m_data);
        str.append(",");
        str.append(this.m_pos);
        str.append("/");
        str.append(this.m_offset);
        str.append("/");
        str.append(this.getLength());
        str.append("]");
        return str.toString();
    }
}

