/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.filesys;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.JCRDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContext {
    private int m_maxFiles;
    private int m_treeId;
    private String m_searchStr;
    private int m_flags;
    private List<Node> m_nodes;
    private int index = -1;

    public SearchContext() {
    }

    public SearchContext(List<Node> results, String srchPath) {
        this.m_searchStr = srchPath;
        this.m_nodes = results;
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final int getMaximumFiles() {
        return this.m_maxFiles;
    }

    public final String getSearchString() {
        return this.m_searchStr != null ? this.m_searchStr : "";
    }

    public final int getTreeId() {
        return this.m_treeId;
    }

    public final void setFlags(int flg) {
        this.m_flags = flg;
    }

    public final void setMaximumFiles(int maxFiles) {
        this.m_maxFiles = maxFiles;
    }

    public final void setSearchString(String str) {
        this.m_searchStr = str;
    }

    public final void setTreeId(int id) {
        this.m_treeId = id;
    }

    public boolean hasMoreFiles() {
        return this.index < this.m_nodes.size() - 1;
    }

    public boolean nextFileInfo(FileInfo info) throws PathNotFoundException, RepositoryException {
        if (!this.hasMoreFiles()) {
            return false;
        }
        ++this.index;
        Node nextNodeRef = this.m_nodes.get(this.index);
        FileInfo nextInfo = JCRDriver.getFileInformation(nextNodeRef);
        info.copyFrom(nextInfo);
        return true;
    }

    public int getResumeId() {
        return this.index;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getSearchString());
        str.append(":");
        str.append(this.getMaximumFiles());
        str.append(",");
        str.append("0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append("]");
        return str.toString();
    }

    public void rollbackAtOnePosition() {
        --this.index;
    }
}

