/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.util.Enumeration;
import java.util.Hashtable;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.auth.Client;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.filesys.JCRNetworkFile;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.SearchContext;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;

public class VirtualCircuit {
    private static final int DefaultTreeConnections = 4;
    private static final int MaxTreeConnections = 16;
    private static final int DefaultSearches = 4;
    private static final int MaxSearches = 256;
    private static final int TreeIdMask = 65535;
    public static final int InvalidUID = -1;
    private int UId = -1;
    private int vcNum = -1;
    private Hashtable<Integer, TreeConnection> connections;
    private int lasttreeId;
    private SearchContext[] searches;
    private int srchCount;
    private Client client;

    public VirtualCircuit(int vcNum, Client client) {
        this.vcNum = vcNum;
        this.client = client;
    }

    public void setUID(int uid) {
        this.UId = uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTreeConnection(SharedDevice shrDev) throws TooManyConnectionsException {
        if (this.connections == null) {
            this.connections = new Hashtable(4);
        }
        int treeId = 0;
        Hashtable<Integer, TreeConnection> hashtable = this.connections;
        synchronized (hashtable) {
            if (this.connections.size() == 16) {
                throw new TooManyConnectionsException();
            }
            treeId = this.lasttreeId++ & 0xFFFF;
            Integer key = new Integer(treeId);
            while (this.connections.contains(key)) {
                treeId = this.lasttreeId++ & 0xFFFF;
                key = new Integer(treeId);
            }
            this.connections.put(key, new TreeConnection(shrDev));
        }
        return treeId;
    }

    public TreeConnection findTreeConnection(int treeId) {
        if (this.connections == null) {
            return null;
        }
        return this.connections.get(new Integer(treeId));
    }

    public final int getConnectionCount() {
        return this.connections != null ? this.connections.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(int treeId, SrvSession sess) {
        if (this.connections == null) {
            return;
        }
        Hashtable<Integer, TreeConnection> hashtable = this.connections;
        synchronized (hashtable) {
            Integer key = new Integer(treeId);
            TreeConnection tree = this.connections.get(key);
            if (tree != null) {
                tree.closeConnection(sess);
                this.connections.remove(key);
            }
        }
    }

    public final void setSearchContext(int slot, SearchContext srch) {
        if (this.searches == null || slot > this.searches.length) {
            return;
        }
        this.searches[slot] = srch;
    }

    public final SearchContext getSearchContext(int srchId) {
        if (this.searches == null || srchId >= this.searches.length) {
            return null;
        }
        return this.searches[srchId];
    }

    public final int allocateSearchSlot() {
        int idx;
        if (this.searches == null) {
            this.searches = new SearchContext[4];
        }
        for (idx = 0; idx < this.searches.length && this.searches[idx] != null; ++idx) {
        }
        if (idx == this.searches.length) {
            if (this.searches.length >= 256) {
                return -1;
            }
            SearchContext[] newSearch = new SearchContext[this.searches.length * 2];
            System.arraycopy(this.searches, 0, newSearch, 0, this.searches.length);
            this.searches = newSearch;
        }
        ++this.srchCount;
        return idx;
    }

    public final void deallocateSearchSlot(int ctxId) {
        if (this.searches == null || ctxId >= this.searches.length) {
            return;
        }
        --this.srchCount;
        this.searches[ctxId] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCircuit(SrvSession sess) {
        if (this.searches != null) {
            for (int idx = 0; idx < this.searches.length; ++idx) {
                if (this.searches[idx] == null) continue;
                this.deallocateSearchSlot(idx);
            }
            this.searches = null;
            this.srchCount = 0;
        }
        if (this.connections != null) {
            Hashtable<Integer, TreeConnection> hashtable = this.connections;
            synchronized (hashtable) {
                Enumeration<TreeConnection> enm = this.connections.elements();
                while (enm.hasMoreElements()) {
                    TreeConnection tree = enm.nextElement();
                    if (tree.openFileCount() <= 0) continue;
                    for (int i = 0; i < tree.getFileTableLength(); ++i) {
                        NetworkFile curFile = tree.findFile(i);
                        if (curFile == null || curFile instanceof JCRNetworkFile) {
                            // empty if block
                        }
                        tree.removeFile(i, sess);
                    }
                }
            }
            this.connections.clear();
        }
    }

    public Client getClientInfo() {
        return this.client;
    }
}

