/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;

public abstract class PacketHandler {
    private int m_protoType;
    private String m_protoName;
    private String m_shortName;
    private Socket m_socket;
    private DataInputStream m_in;
    private DataOutputStream m_out;
    private String m_clientName;

    public PacketHandler(Socket sock, int typ, String name, String shortName) throws IOException {
        this.m_socket = sock;
        this.m_protoType = typ;
        this.m_protoName = name;
        this.m_shortName = shortName;
        sock.setTcpNoDelay(true);
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
    }

    public PacketHandler(int typ, String name, String shortName, String clientName) {
        this.m_protoType = typ;
        this.m_protoName = name;
        this.m_shortName = shortName;
        this.m_clientName = clientName;
    }

    public final int isProtocol() {
        return this.m_protoType;
    }

    public final String isProtocolName() {
        return this.m_protoName;
    }

    public final String getShortName() {
        return this.m_shortName;
    }

    public final boolean hasRemoteAddress() {
        return this.m_socket != null;
    }

    public final InetAddress getRemoteAddress() {
        return this.m_socket != null ? this.m_socket.getInetAddress() : null;
    }

    public final boolean hasClientName() {
        return this.m_clientName != null;
    }

    public final String getClientName() {
        return this.m_clientName;
    }

    public final int availableBytes() throws IOException {
        if (this.m_in != null) {
            return this.m_in.available();
        }
        return 0;
    }

    public final int readPacket(byte[] pkt, int off, int len) throws IOException {
        if (this.m_in != null) {
            return this.m_in.read(pkt, off, len);
        }
        return 0;
    }

    public abstract int readPacket(SMBSrvPacket var1) throws IOException;

    public final void writePacket(byte[] pkt, int off, int len) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(pkt, off, len);
        }
    }

    public abstract void writePacket(SMBSrvPacket var1, int var2) throws IOException;

    public final void writePacket(SMBSrvPacket pkt) throws IOException {
        this.writePacket(pkt, pkt.getLength());
    }

    public final void flushPacket() throws IOException {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    public void closeHandler() {
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_out = null;
        }
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socket = null;
        }
    }
}

