/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs;

import java.net.URL;
import org.exoplatform.container.StandaloneContainer;

public class CIFSServerRun {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("CIFS Server Test by Exo Platform");
        System.out.println("--------------------------------");
        try {
            URL configurationURL = Thread.currentThread().getContextClassLoader().getResource("conf/cifs-configuration.xml");
            if (configurationURL == null) {
                throw new Exception("No configuration found. Check that \"conf/cifs-configuration.xml\" exists !");
            }
            StandaloneContainer.addConfigurationURL((String)configurationURL.toString());
            StandaloneContainer container = StandaloneContainer.getInstance();
            URL loginURL = Thread.currentThread().getContextClassLoader().getResource("login.conf");
            if (loginURL == null) {
                throw new Exception("No login config found. Check that resource login.conf exists !");
            }
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", loginURL.toString());
            }
            System.out.println("Enter 'x' to shutdown ...");
            boolean shutdown = false;
            while (!shutdown) {
                int ch = System.in.read();
                if (ch == 120 || ch == 88) {
                    shutdown = true;
                }
                StandaloneContainer standaloneContainer = container;
                synchronized (standaloneContainer) {
                    container.wait(20L);
                }
            }
            container.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(1);
    }
}

