/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.ext.replication.PendingChangesLog;
import org.exoplatform.services.jcr.ext.replication.recovery.AbstractFSAccess;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryReader
extends AbstractFSAccess {
    private static Log log = ExoLogger.getLogger((String)"ext.RecoveryReader");
    private FileCleaner fileCleaner;
    private File recoveryDir;

    public RecoveryReader(FileCleaner fileCleaner, File recoveryDir) {
        this.fileCleaner = fileCleaner;
        this.recoveryDir = recoveryDir;
    }

    public TransactionChangesLog getChangesLog(String filePath) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filePath));
        TransactionChangesLog tcl = this.readExternal(ois);
        ois.close();
        return tcl;
    }

    private TransactionChangesLog readExternal(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int changesLogType = in.readInt();
        TransactionChangesLog transactionChangesLog = null;
        if (changesLogType == 2) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
            int iFixupStream = in.readInt();
            ArrayList<FixupStream> listFixupStreams = new ArrayList<FixupStream>();
            for (int i = 0; i < iFixupStream; ++i) {
                listFixupStreams.add((FixupStream)in.readObject());
            }
            int iStreamCount = in.readInt();
            ArrayList<File> listFiles = new ArrayList<File>();
            for (int i = 0; i < iStreamCount; ++i) {
                long fileSize = in.readLong();
                File contentFile = this.getAsFile(in, fileSize);
                listFiles.add(contentFile);
            }
            PendingChangesLog pendingChangesLog = new PendingChangesLog(transactionChangesLog, listFixupStreams, listFiles, this.fileCleaner);
            pendingChangesLog.restore();
        } else if (changesLogType == 1) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
        }
        return transactionChangesLog;
    }

    public List<String> getFilePathList(Calendar timeStamp, String ownName) throws IOException {
        File dataInfo = new File(this.recoveryDir.getAbsolutePath() + File.separator + ownName);
        ArrayList<String> list = new ArrayList<String>();
        if (dataInfo.exists()) {
            String sPath;
            BufferedReader br = new BufferedReader(new FileReader(dataInfo));
            while ((sPath = br.readLine()) != null) {
                if (sPath.startsWith("---")) continue;
                File f = new File(sPath);
                Calendar time = this.getTimeStamp(f.getName());
                if (!timeStamp.after(time)) break;
                list.add(sPath);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sPath);
            }
        }
        return list;
    }

    private Calendar getTimeStamp(String fileName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        Calendar timeStamp = Calendar.getInstance();
        try {
            timeStamp.setTime(dateFormat.parse(fileName));
        }
        catch (ParseException e) {
            log.error((Object)"Can't parce date", (Throwable)e);
        }
        return timeStamp;
    }
}

