/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.registry.transformer;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.rest.transformer.InputEntityTransformer;

/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: RegistryEntryInputTransformer.java 35186 2009-08-07 14:23:43Z pnedonosko $
 */
public class RegistryEntryInputTransformer extends InputEntityTransformer {

  public RegistryEntry readFrom(InputStream entityDataStream) throws IOException {
    try {
      return RegistryEntry.parse(entityDataStream);
    } catch (ParserConfigurationException pce) {
      throw new IOException("Can't read from input stream " + pce);
    } catch (SAXException saxe) {
      throw new IOException("Can't read from input stream " + saxe);
    }
  }

}
