/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;

public class LockTestCase
extends BaseReplicationTestCase {
    public LockTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        log.info((Object)"LockTestCase inited");
    }

    public StringBuffer lock(String repoPath) {
        StringBuffer sb = new StringBuffer();
        try {
            Node lockNode = this.addNodePath(repoPath);
            lockNode.setProperty("jcr:data", "node data");
            lockNode.addMixin("mix:lockable");
            this.session.save();
            Lock lock = lockNode.lock(false, false);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't locked: ", (Throwable)e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer isLocked(String repoPath) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node destNodeLocked = (Node)this.session.getItem(normalizePath);
            destNodeLocked.setProperty("jcr:data", "dd");
            this.session.save();
            sb.append("fail");
            log.error((Object)"Errore: Node is not locked");
        }
        catch (LockException e) {
            sb.append("ok");
        }
        catch (RepositoryException e) {
            sb.append("fail");
            log.error((Object)"The error checking lock :", (Throwable)e);
        }
        return sb;
    }
}

