/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.jcr.ext.resource.jcr.Handler;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestUpdateListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ResourceBinder;
import org.exoplatform.services.rest.container.InvalidResourceDescriptorException;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GroovyScript2RestLoader
implements Startable {
    public static final String DEFAULT_NODETYPE = "exo:groovyResourceContainer";
    private static final Log Log = ExoLogger.getLogger((String)"jcr.script.GroovyScript2RestLoader");
    private static final String SERVICE_NAME = "GroovyScript2RestLoader";
    private InitParams initParams;
    private ResourceBinder binder;
    private GroovyScriptInstantiator groovyScriptInstantiator;
    private Handler handler;
    private RepositoryService repositoryService;
    private RegistryService registryService;
    private ObservationListenerConfiguration observationListenerConfiguration;
    private String nodeType;
    private Map<String, String> scriptsURL2ClassName = new HashMap<String, String>();
    private static Log log = ExoLogger.getLogger((String)"jcr.GroovyScrip2RestLoader");

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, Handler handler, RepositoryService repositoryService, InitParams params) {
        this(binder, groovyScriptInstantiator, handler, repositoryService, null, params);
    }

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, Handler handler, RepositoryService repositoryService, RegistryService registryService, InitParams params) {
        this.binder = binder;
        this.groovyScriptInstantiator = groovyScriptInstantiator;
        this.repositoryService = repositoryService;
        this.handler = handler;
        this.registryService = registryService;
        this.initParams = params;
    }

    public void unloadScript(URL url) {
        this.unloadScript(url.toString());
    }

    public void unloadScript(String key) {
        if (!this.scriptsURL2ClassName.containsKey(key)) {
            throw new IllegalArgumentException("Specified key '" + key + "' does not corresponds to any class name.");
        }
        this.binder.unbind(this.scriptsURL2ClassName.get(key));
        this.scriptsURL2ClassName.remove(key);
    }

    public void loadScript(URL url) throws InvalidResourceDescriptorException, IOException {
        ResourceContainer resourceContainer = (ResourceContainer)this.groovyScriptInstantiator.instantiateScript(url);
        this.binder.bind(resourceContainer);
        this.scriptsURL2ClassName.put(url.toString(), resourceContainer.getClass().getName());
        Log.info((Object)("Add new groovy scripts, URL: " + url));
    }

    public void loadScript(String key, InputStream stream) throws InvalidResourceDescriptorException, IOException {
        ResourceContainer resourceContainer = (ResourceContainer)this.groovyScriptInstantiator.instantiateScript(stream);
        this.binder.bind(resourceContainer);
        this.scriptsURL2ClassName.put(key, resourceContainer.getClass().getName());
        Log.info((Object)("Add new groovy scripts, script key: " + key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    log.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
        if (this.observationListenerConfiguration == null) {
            return;
        }
        try {
            String repositoryName = this.observationListenerConfiguration.getRepository();
            List<String> workspaceNames = this.observationListenerConfiguration.getWorkspaces();
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            for (String workspaceName : workspaceNames) {
                Session session = repository.getSystemSession(workspaceName);
                session.getWorkspace().getObservationManager().addEventListener((EventListener)new GroovyScript2RestUpdateListener(repositoryName, workspaceName, this, session), 20, "/", true, null, new String[]{this.nodeType}, false);
                String xpath = "//element(*, " + this.nodeType + ")[@exo:autoload='true']";
                Query query = session.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    if (node.getPath().startsWith("/jcr:system")) continue;
                    UnifiedNodeReference unifiedNodeReference = new UnifiedNodeReference(repositoryName, workspaceName, node.getPath());
                    this.loadScript(unifiedNodeReference.getURL().toString(), node.getProperty("jcr:data").getStream());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        this.observationListenerConfiguration = new ObservationListenerConfiguration();
        String entryPath = "exo:services/GroovyScript2RestLoader/nodeType";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.nodeType = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/GroovyScript2RestLoader/repository";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.observationListenerConfiguration.setRepository(this.getAttributeSmart(element, "value"));
        entryPath = "exo:services/GroovyScript2RestLoader/workspaces";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        String workspaces = this.getAttributeSmart(element, "value");
        String[] ws = workspaces.split(";");
        ArrayList<String> wsList = new ArrayList<String>();
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i].equals("")) continue;
            wsList.add(ws[i]);
        }
        this.observationListenerConfiguration.setWorkspaces(wsList);
        log.info((Object)("NodeType from RegistryService: " + this.nodeType));
        log.info((Object)("Repository from RegistryService: " + this.observationListenerConfiguration.getRepository()));
        log.info((Object)("Workspaces node from RegistryService: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement("nodeType");
        this.setAttributeSmart(element, "value", this.nodeType);
        root.appendChild(element);
        String workspaces = "";
        for (String workspace : this.observationListenerConfiguration.getWorkspaces()) {
            workspaces = workspaces + workspace + ";";
        }
        element = doc.createElement("workspaces");
        this.setAttributeSmart(element, "value", workspaces);
        root.appendChild(element);
        element = doc.createElement("repository");
        this.setAttributeSmart(element, "value", this.observationListenerConfiguration.getRepository());
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        if (this.initParams != null) {
            this.nodeType = this.initParams.getValuesParam("nodetype") != null ? this.initParams.getValueParam("nodetype").getValue() : DEFAULT_NODETYPE;
            ObjectParameter param = this.initParams.getObjectParam("observation.config");
            this.observationListenerConfiguration = (ObservationListenerConfiguration)param.getObject();
        }
        log.info((Object)("NodeType from configuration file: " + this.nodeType));
        log.info((Object)("Repository from configuration file: " + this.observationListenerConfiguration.getRepository()));
        log.info((Object)("Workspaces node from configuration file: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObservationListenerConfiguration {
        private String repository;
        private List<String> workspaces;

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public List<String> getWorkspaces() {
            return this.workspaces;
        }

        public void setWorkspaces(List<String> workspaces) {
            this.workspaces = workspaces;
        }
    }
}

