/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;

public class MembershipHandlerImpl
extends CommonHandler
implements MembershipHandler {
    public static final String EXO_GROUP = "exo:group";
    public static final String EXO_MEMBERSHIP_TYPE = "exo:membershipType";
    protected final List<MembershipEventListener> listeners = new ArrayList<MembershipEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.MembershipHandlerImpl");

    MembershipHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMembership(Membership m, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createMembership(session, m, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createMembership(Session session, Membership m, boolean broadcast) throws Exception {
        try {
            Group g = ((GroupHandlerImpl)this.service.getGroupHandler()).findGroupById(session, m.getGroupId());
            User u = ((UserHandlerImpl)this.service.getUserHandler()).findUserByName(session, m.getUserName());
            MembershipType mt = this.service.getMembershipTypeHandler().createMembershipTypeInstance();
            mt.setName(m.getMembershipType());
            this.linkMembership(session, u, g, mt, broadcast);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create membership", e);
        }
    }

    public Membership createMembershipInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createMembershipInstance");
        }
        return new MembershipImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembership(String id) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembership(session, id);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership findMembership(Session session, String id) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembership");
        }
        try {
            Node mNode = session.getNodeByUUID(id);
            return this.readObjectFromNode(session, mNode);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by UUId", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembershipByUserGroupAndType(session, userName, groupId, type);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership findMembershipByUserGroupAndType(Session session, String userName, String groupId, String type) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserGroupAndType");
        }
        try {
            String membershipTypeUUId;
            MembershipImpl membership = null;
            String groupUUId = this.getGroupUUID(session, groupId);
            if (groupUUId != null && (membershipTypeUUId = this.getMembershipTypeUUID(session, type)) != null) {
                String mStatement = "select * from exo:userMembership where exo:group='" + groupUUId + "' and exo:membershipType='" + membershipTypeUUId + "'";
                Query mQuery = this.service.getStorageSession().getWorkspace().getQueryManager().createQuery(mStatement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    Node uNode = mNode.getParent();
                    if (!uNode.getName().equals(userName)) continue;
                    if (membership != null) {
                        throw new OrganizationServiceException("More than one membership is found");
                    }
                    membership = new MembershipImpl(mNode.getUUID(), userName, groupId, type);
                }
            }
            return membership;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type for user '" + userName + "' groupId '" + groupId + "' type '" + type + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByGroup(Group group) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByGroup(session, group);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByGroup(Session session, Group group) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByGroup");
        }
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String groupUUID = this.getGroupUUID(session, group.getId());
            if (groupUUID != null) {
                String statement = "select * from exo:userMembership where exo:group='" + groupUUID + "'";
                Query mQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    types.add(this.readObjectFromNode(session, mNode));
                }
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by group", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUser(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByUser(session, userName);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByUser(Session session, String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembeshipByUser");
        }
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String userPath = this.service.getStoragePath() + "/" + "exo:users" + "/" + userName;
            if (!session.itemExists(userPath)) {
                return types;
            }
            String mStatement = "select * from exo:userMembership";
            Query mQuery = session.getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Node uNode = mNode.getParent();
                if (!uNode.getName().equals(userName)) continue;
                types.add(this.readObjectFromNode(session, mNode));
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByUserAndGroup(session, userName, groupId);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByUserAndGroup(Session session, String userName, String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findMembershipByUserAndGroup");
        }
        try {
            ArrayList<Membership> types = new ArrayList<Membership>();
            String groupUUId = this.getGroupUUID(session, groupId);
            if (groupUUId != null) {
                String mStatement = "select * from exo:userMembership where exo:group='" + groupUUId + "'";
                Query mQuery = session.getWorkspace().getQueryManager().createQuery(mStatement, "sql");
                QueryResult mRes = mQuery.execute();
                NodeIterator mNodes = mRes.getNodes();
                while (mNodes.hasNext()) {
                    Node mNode = mNodes.nextNode();
                    Node uNode = mNode.getParent();
                    if (!uNode.getName().equals(userName)) continue;
                    types.add(this.readObjectFromNode(session, mNode));
                }
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by user '" + userName + "' and group '" + groupId + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.linkMembership(session, user, group, m, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void linkMembership(Session session, User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"linkMembership");
        }
        if (group == null) {
            throw new OrganizationServiceException("Can not create membership record for user '" + user.getUserName() + "' because group not found");
        }
        if (m == null) {
            throw new OrganizationServiceException("Can not create membership record for user '" + user.getUserName() + "' because membership type not found");
        }
        try {
            if (m.getName().equals("*") && !session.itemExists(this.service.getStoragePath() + "/" + "exo:membershipTypes" + "/" + m.getName())) {
                MembershipType mt = this.service.getMembershipTypeHandler().createMembershipTypeInstance();
                mt.setName("*");
                mt.setDescription("any membership type");
                ((MembershipTypeHandlerImpl)this.service.getMembershipTypeHandler()).createMembershipType(session, mt, broadcast);
            }
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + user.getUserName());
            MembershipImpl membership = new MembershipImpl(null, user.getUserName(), group.getId(), m.getName());
            Node mNode = uNode.addNode("exo:membership");
            if (broadcast) {
                this.preSave(membership, true);
            }
            this.writeObjectToNode(session, membership, mNode);
            session.save();
            if (broadcast) {
                this.postSave(membership, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not link membership record for user '" + user.getUserName() + "' group '" + group.getGroupName() + "' and membership type '" + m.getName() + "'", e);
        }
    }

    Membership removeMembership(Session session, String id, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembership");
        }
        try {
            Node mNode = session.getNodeByUUID(id);
            Membership membership = this.readObjectFromNode(session, mNode);
            if (broadcast) {
                this.preDelete(membership);
            }
            mNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(membership);
            }
            return membership;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership by UUId", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.removeMembership(session, id, broadcast);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.removeMembershipByUser(session, userName, broadcast);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection removeMembershipByUser(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removeMembershipByUser");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users" + "/" + userName);
            List types = new ArrayList();
            types = (List)this.findMembershipsByUser(session, userName);
            NodeIterator mNodes = uNode.getNodes("exo:membership");
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                Membership membership = this.readObjectFromNode(session, mNode);
                if (broadcast) {
                    this.preDelete(membership);
                }
                mNode.remove();
            }
            session.save();
            for (int i = 0; i < types.size(); ++i) {
                if (!broadcast) continue;
                this.postDelete((Membership)types.get(i));
            }
            return types;
        }
        catch (PathNotFoundException e) {
            throw new OrganizationServiceException("Can not find user '" + userName + "' for remove membership.");
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership by user '" + userName + "'", e);
        }
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        this.listeners.remove(listener);
    }

    private String getMembershipTypeUUID(Session session, String type) throws Exception {
        try {
            String mtPath = this.service.getStoragePath() + "/" + "exo:membershipTypes";
            return type != null && type.length() != 0 && session.itemExists(mtPath + "/" + type) ? ((Node)session.getItem(mtPath + "/" + type)).getUUID() : null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type '" + type + "'", e);
        }
    }

    private String getGroupUUID(Session session, String groupId) throws Exception {
        try {
            String gPath = this.service.getStoragePath() + "/" + "exo:groups";
            return groupId != null && groupId.length() != 0 && session.itemExists(gPath + groupId) ? ((Node)session.getItem(gPath + groupId)).getUUID() : null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group '" + groupId + "'", e);
        }
    }

    private String getMembershipType(Session session, String UUID) throws Exception {
        try {
            return session.getNodeByUUID(UUID).getName();
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type by uuid " + UUID, e);
        }
    }

    private String getGroupId(Session session, String UUID) throws Exception {
        try {
            Node gNode = session.getNodeByUUID(UUID);
            return this.readStringProperty(gNode, "exo:groupId");
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find group by uuid " + UUID, e);
        }
    }

    private Membership readObjectFromNode(Session session, Node node) throws Exception {
        try {
            String groupUUID = this.readStringProperty(node, EXO_GROUP);
            String membershipTypeUUID = this.readStringProperty(node, EXO_MEMBERSHIP_TYPE);
            String groupId = this.getGroupId(session, groupUUID);
            String membershipType = this.getMembershipType(session, membershipTypeUUID);
            String userName = node.getParent().getName();
            return new MembershipImpl(node.getUUID(), userName, groupId, membershipType);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read membership properties", e);
        }
    }

    private void writeObjectToNode(Session session, Membership m, Node node) throws Exception {
        try {
            String groupUUId = this.getGroupUUID(session, m.getGroupId());
            String membershipTypeUUId = this.getMembershipTypeUUID(session, m.getMembershipType());
            node.setProperty(EXO_GROUP, groupUUId);
            node.setProperty(EXO_MEMBERSHIP_TYPE, membershipTypeUUId);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write membership properties", e);
        }
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (int i = 0; i < this.listeners.size(); ++i) {
            MembershipEventListener listener = this.listeners.get(i);
            listener.postDelete(membership);
        }
    }
}

