/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.tagging;

import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.tagging.Tag;
import org.exoplatform.services.jcr.ext.tagging.TagRate;
import org.exoplatform.services.jcr.ext.tagging.TagURICrossrate;
import org.exoplatform.services.jcr.ext.tagging.TaggingService;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingServiceImpl
implements TaggingService {
    private RepositoryService repoService;
    private RegistryService registryService;

    public TaggingServiceImpl(InitParams params, RegistryService registryService, RepositoryService repoService) {
        this.repoService = repoService;
        this.registryService = registryService;
    }

    @Override
    public void addTag(String name, URI uri, String description, String repository, String workspace) throws RepositoryException, RepositoryConfigurationException {
        String user = ConversationState.getCurrent().getIdentity().getUserId();
        Node root = this.root(repository, workspace, ConversationState.getCurrent());
        Node tag = root.getNode("tags").hasNode(name) ? root.getNode("tags").getNode(name) : root.getNode("tags").addNode(name, "exo:tag");
        Node userTags = tag.hasNode(user) ? tag.getNode(user) : tag.addNode(user, "exo:userTags");
        Node userTag = userTags.hasNode(name) ? userTags.getNode(name) : userTags.addNode(name, "exo:userTag");
        userTag.setProperty("exo:uri", uri.toASCIIString());
        userTag.setProperty("exo:description", description);
        root.save();
    }

    @Override
    public TagURICrossrate getCrossrate(String tagName, URI uri) {
        return null;
    }

    @Override
    public Collection<TagURICrossrate> getCrossrate(URI uri) {
        return null;
    }

    @Override
    public TagRate getRate(String tagName) {
        return null;
    }

    @Override
    public Collection<TagRate> getRates() {
        return null;
    }

    @Override
    public Collection<TagRate> getRates(Comparator comparator) {
        return null;
    }

    @Override
    public Collection<Tag> getTags(String userId) {
        return null;
    }

    @Override
    public Collection<Tag> getTags(URI uri) {
        return null;
    }

    private Node root(String repoName, String workspaceName, ConversationState state) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repository = this.repoService.getRepository(repoName);
        SessionProvider sp = (SessionProvider)state.getAttribute("JCRsessionProvider");
        RegistryEntry re = this.registryService.getEntry(sp, "exo:services/tagging");
        return sp.getSession(workspaceName, repository).getRootNode();
    }
}

