/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.synchronization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.log.ExoLogger;

public class BackupOperator {
    private Log log = ExoLogger.getLogger((String)"ext.BackupOperator");
    protected final BackupManager backupManager;

    BackupOperator(BackupManager backupManager) {
        this.backupManager = backupManager;
    }

    public Task fullBackup(String repository, String workspace) throws RepositoryException, BackupOperationException, BackupConfigurationException, RepositoryConfigurationException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File backDir = new File(tmpdir, "syncservice-backup-tmpdir");
        backDir.mkdirs();
        BackupConfig config = new BackupConfig();
        config.setRepository(repository);
        config.setWorkspace(workspace);
        config.setBuckupType(0);
        config.setBackupDir(backDir);
        this.backupManager.startBackup(config);
        BackupChain bch = this.backupManager.findBackup(repository, workspace);
        if (bch != null) {
            while (bch.getFullBackupState() != 4) {
                Thread.yield();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            this.backupManager.stopBackup(bch);
            return new Task(repository, workspace, backDir);
        }
        throw new RepositoryException("Can't get fullBackup chain");
    }

    class Task {
        final String repository;
        final String workspace;
        final File tmpdir;

        Task(String repository, String workspace, File tmpdir) {
            this.repository = repository;
            this.workspace = workspace;
            this.tmpdir = tmpdir;
        }

        InputStream getContent() throws FileNotFoundException {
            return new FileInputStream(new File(this.tmpdir, ""));
        }

        void close() {
            for (File f : this.tmpdir.listFiles()) {
                if (f.delete()) continue;
                f.deleteOnExit();
            }
        }
    }
}

