/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.synchronization;

import java.io.IOException;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

@URITemplate(value="/synchronization/")
@OutputTransformer(value=StringOutputTransformer.class)
public class SynchronizationService
implements ResourceContainer {
    public static final String ID_DELIMITER = "$|";
    protected final RepositoryService repoService;
    protected final BackupManager backupManager;
    protected final InitParams params;

    protected RequestIdentity parseIdentityLine(String identityLine) throws IOException {
        String password;
        String userName;
        String l = new String(Base64.decode((String)identityLine));
        String[] lpair = l.split(ID_DELIMITER);
        if (lpair.length > 0) {
            userName = lpair[0];
            password = lpair.length > 1 ? lpair[1] : lpair[1];
        } else {
            password = null;
            userName = null;
        }
        return new RequestIdentity(userName, password);
    }

    protected String makeIdentityLine(RequestIdentity identity) {
        String l = identity.userName + ID_DELIMITER + identity.password;
        return new String(Base64.encode((byte[])l.getBytes()));
    }

    public SynchronizationService(RepositoryService repoService, BackupManager backupManager, InitParams params) {
        this.repoService = repoService;
        this.backupManager = backupManager;
        this.params = params;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/hostfullbackup/{repositoryName}/{workspaceName}/{resourcePath}/")
    public Response hostFullBackup(@URIParam(value="repositoryName") String repositoryName, @URIParam(value="workspaceName") String workspaceName, @URIParam(value="resourcePath") String resourcePath, @URIParam(value="fileName") String fileName, @QueryParam(value="id") String identityLine) {
        try {
            RequestIdentity identity = this.parseIdentityLine(identityLine);
            return Response.Builder.ok((Object)"TODO".toString(), (String)"text/plain").build();
        }
        catch (IOException e) {
            return Response.Builder.ok((Object)"TODO".toString(), (String)"text/plain").build();
        }
    }

    protected class RequestIdentity {
        final String userName;
        final String password;

        RequestIdentity(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }
    }
}

