/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ValueFormatException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupChainLog {
    protected static Log logger = ExoLogger.getLogger((String)"ext.BackupChainLog");
    private static final String PREFIX = "backup-";
    private static final String SUFFIX = ".xml";
    private File log;
    private String configInfo;
    private final List<JobEntryInfo> jobEntries;
    private LogWriter logWriter;
    private LogReader logReader;
    private BackupConfig config;
    private String backupId;

    public BackupChainLog(File logDir, BackupConfig config, String fullBackupType, String incrementalBackupType, String backupId) throws BackupOperationException {
        try {
            this.log = new File(logDir.getCanonicalPath() + File.separator + PREFIX + backupId + SUFFIX);
            this.log.createNewFile();
            this.backupId = backupId;
            this.config = config;
            this.jobEntries = new ArrayList<JobEntryInfo>();
            this.logWriter = new LogWriter(this.log);
            this.logWriter.write(config, fullBackupType, incrementalBackupType);
        }
        catch (IOException e) {
            throw new BackupOperationException(e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException(e);
        }
    }

    public BackupChainLog(File log) throws BackupOperationException {
        this.log = log;
        this.backupId = log.getName().replaceAll(PREFIX, "").replaceAll(SUFFIX, "");
        try {
            this.logReader = new LogReader(log);
            this.logReader.readLogFile();
            this.logReader.jobEntrysNormalize();
            this.config = this.logReader.getBackupConfig();
            this.jobEntries = this.logReader.getJobEntryInfoNormalizeList();
            for (JobEntryInfo info : this.jobEntries) {
                if (info.getType() != 2) continue;
                this.config.setBackupType(1);
                break;
            }
        }
        catch (FileNotFoundException e) {
            throw new BackupOperationException(e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException(e);
        }
        catch (MalformedURLException e) {
            throw new BackupOperationException(e);
        }
        catch (ValueFormatException e) {
            throw new BackupOperationException(e);
        }
    }

    public void addJobEntry(BackupJob job) {
        try {
            JobEntryInfo info = new JobEntryInfo();
            info.setDate(Calendar.getInstance());
            info.setType(job.getType());
            info.setState(job.getState());
            info.setURL(job.getStorageURL());
            this.logWriter.write(info);
        }
        catch (Exception e) {
            logger.error((Object)"Can't add job", (Throwable)e);
        }
    }

    public String getBackupId() {
        return this.backupId;
    }

    public String getConfigInfo() {
        return this.configInfo;
    }

    public List<JobEntryInfo> getJobEntryInfos() {
        return this.jobEntries;
    }

    public void endLog() {
        this.logWriter.writeEndLog();
    }

    public Collection<JobEntryInfo> getJobEntryStates() {
        HashMap<Integer, JobEntryInfo> infos = new HashMap<Integer, JobEntryInfo>();
        for (JobEntryInfo jobEntry : this.jobEntries) {
            infos.put(jobEntry.getID(), jobEntry);
        }
        return infos.values();
    }

    public BackupConfig getBackupConfig() {
        return this.config;
    }

    public String getLogFilePath() {
        return this.log.getAbsolutePath();
    }

    class LogWriter {
        protected Log logger = ExoLogger.getLogger((String)"ext.LogWriter");
        private File logFile;
        XMLStreamWriter writer;

        public LogWriter(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(this.logFile));
            this.writer.writeStartDocument();
            this.writer.writeStartElement("backup-cain-log");
            this.writer.flush();
        }

        public synchronized void write(BackupConfig config, String fullBackupType, String incrementalBackupType) throws XMLStreamException {
            this.writer.writeStartElement("backup-config");
            this.writer.writeStartElement("full-backup-type");
            this.writer.writeCharacters(fullBackupType);
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-backup-type");
            this.writer.writeCharacters(incrementalBackupType);
            this.writer.writeEndElement();
            if (config.getBackupDir() != null) {
                this.writer.writeStartElement("backup-dir");
                this.writer.writeCharacters(config.getBackupDir().getAbsolutePath());
                this.writer.writeEndElement();
            }
            if (config.getRepository() != null) {
                this.writer.writeStartElement("repository");
                this.writer.writeCharacters(config.getRepository());
                this.writer.writeEndElement();
            }
            if (config.getWorkspace() != null) {
                this.writer.writeStartElement("workspace");
                this.writer.writeCharacters(config.getWorkspace());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("incremental-job-period");
            this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void write(JobEntryInfo info) throws XMLStreamException {
            this.writer.writeStartElement("job-entry-info");
            this.writer.writeStartElement("type");
            this.writer.writeCharacters(info.getType() == 1 ? "FULL" : "INCREMENTAL");
            this.writer.writeEndElement();
            this.writer.writeStartElement("state");
            this.writer.writeCharacters(this.getState(info.getState()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("url");
            this.writer.writeCharacters(info.getURL().toString());
            this.writer.writeEndElement();
            this.writer.writeStartElement("date");
            this.writer.writeCharacters(JCRDateFormat.format((Calendar)info.getDate()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void writeEndLog() {
            try {
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.error((Object)"Can't write log", (Throwable)e);
            }
        }

        private String getState(int iState) {
            String sState = "" + iState;
            switch (iState) {
                case 4: {
                    sState = "FINISHED";
                    break;
                }
                case 0: {
                    sState = "STARTING";
                    break;
                }
                case 1: {
                    sState = "WAITING";
                    break;
                }
                case 2: {
                    sState = "WORKING";
                }
            }
            return sState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogReader {
        protected Log logger = ExoLogger.getLogger((String)"ext.LogWriter");
        private File logFile;
        private XMLStreamReader reader;
        private BackupConfig config;
        private List<JobEntryInfo> jobEntries;
        private List<JobEntryInfo> jobEntriesNormalize;

        public LogReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.jobEntries = new ArrayList<JobEntryInfo>();
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(this.logFile));
        }

        public BackupConfig getBackupConfig() {
            return this.config;
        }

        public List<JobEntryInfo> getJobEntryInfoList() {
            return this.jobEntries;
        }

        public List<JobEntryInfo> getJobEntryInfoNormalizeList() {
            return this.jobEntriesNormalize;
        }

        public void readLogFile() throws XMLStreamException, MalformedURLException, ValueFormatException {
            boolean endDocument = false;
            while (!endDocument) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-config")) {
                            this.config = this.readBackupConfig();
                        }
                        if (!name.equals("job-entry-info")) break;
                        this.jobEntries.add(this.readJobEntryInfo());
                        break;
                    }
                    case 8: {
                        endDocument = true;
                    }
                }
            }
        }

        private JobEntryInfo readJobEntryInfo() throws XMLStreamException, MalformedURLException, ValueFormatException {
            JobEntryInfo info = new JobEntryInfo();
            boolean endJobEntryInfo = false;
            while (!endJobEntryInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("type")) {
                            info.setType(this.getType(this.readContent()));
                        }
                        if (name.equals("state")) {
                            info.setState(this.getState(this.readContent()));
                        }
                        if (name.equals("url")) {
                            info.setURL(new URL(this.readContent()));
                        }
                        if (!name.equals("date")) break;
                        info.setDate(JCRDateFormat.parse((String)this.readContent()));
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("job-entry-info")) break;
                        endJobEntryInfo = true;
                    }
                }
            }
            return info;
        }

        private int getState(String content) {
            int state = -1;
            if (content.equals("FINISHED")) {
                state = 4;
            }
            if (content.equals("STARTING")) {
                state = 0;
            }
            if (content.equals("WAITING")) {
                state = 1;
            }
            if (content.equals("WORKING")) {
                state = 2;
            }
            return state;
        }

        private int getType(String content) {
            int type = -1;
            if (content.equals("FULL")) {
                type = 1;
            }
            if (content.equals("INCREMENTAL")) {
                type = 2;
            }
            return type;
        }

        private BackupConfig readBackupConfig() throws XMLStreamException {
            BackupConfig conf = new BackupConfig();
            boolean endBackupConfig = false;
            while (!endBackupConfig) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-dir")) {
                            conf.setBackupDir(new File(this.readContent()));
                        }
                        if (name.equals("repository")) {
                            conf.setRepository(this.readContent());
                        }
                        if (name.equals("workspace")) {
                            conf.setWorkspace(this.readContent());
                        }
                        if (!name.equals("incremental-job-period")) break;
                        conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("backup-config")) break;
                        endBackupConfig = true;
                    }
                }
            }
            return conf;
        }

        private String readContent() throws XMLStreamException {
            String content = null;
            int eventCode = this.reader.next();
            if (eventCode == 4) {
                content = this.reader.getText();
            }
            return content;
        }

        public void jobEntrysNormalize() {
            this.jobEntriesNormalize = new ArrayList<JobEntryInfo>();
            for (int i = 0; i < this.jobEntries.size(); ++i) {
                JobEntryInfo entryInfo = this.jobEntries.get(i);
                boolean alreadyExist = false;
                for (int j = 0; j < this.jobEntriesNormalize.size(); ++j) {
                    if (!this.jobEntriesNormalize.get(j).getURL().toString().equals(entryInfo.getURL().toString())) continue;
                    alreadyExist = true;
                }
                if (alreadyExist) continue;
                this.jobEntriesNormalize.add(entryInfo);
            }
        }
    }
}

