/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.server.bean.response;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;

public class ShortInfo {
    public static final int CURRENT = -1;
    public static final int COMPLETED = 0;
    public static final int RESTORE = 1;
    private Integer type;
    private String backupId;
    private Integer backupType;
    private String repositoryName;
    private String workspaceName;
    private Integer state;
    private String startedTime;
    private String finishedTime;

    public ShortInfo() {
    }

    public ShortInfo(int type, BackupChain chain) {
        this.type = type;
        this.backupType = chain.getBackupConfig().getBackupType();
        this.backupId = chain.getBackupId();
        this.repositoryName = chain.getBackupConfig().getRepository();
        this.workspaceName = chain.getBackupConfig().getWorkspace();
        this.state = chain.getFullBackupState();
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        this.startedTime = df.format(chain.getStartedTime().getTime());
        this.finishedTime = "";
    }

    public ShortInfo(int type, BackupChainLog chainLog) {
        this.type = type;
        this.backupType = chainLog.getBackupConfig().getBackupType();
        this.backupId = chainLog.getBackupId();
        this.repositoryName = chainLog.getBackupConfig().getRepository();
        this.workspaceName = chainLog.getBackupConfig().getWorkspace();
        this.state = 0;
        for (JobEntryInfo info : chainLog.getJobEntryInfos()) {
            if (info.getType() != 1) continue;
            SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            this.startedTime = df.format(info.getDate().getTime());
            break;
        }
        this.finishedTime = "";
    }

    public ShortInfo(int type, BackupChainLog chainLog, Calendar startedTime, Calendar finishedTime, int state) {
        this.type = type;
        this.backupType = chainLog.getBackupConfig().getBackupType();
        this.backupId = chainLog.getBackupId();
        this.repositoryName = chainLog.getBackupConfig().getRepository();
        this.workspaceName = chainLog.getBackupConfig().getWorkspace();
        this.state = state;
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        this.startedTime = df.format(startedTime.getTime());
        this.finishedTime = finishedTime != null ? df.format(finishedTime.getTime()) : "";
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getStartedTime() {
        return this.startedTime;
    }

    public void setStartedTime(String startedTime) {
        this.startedTime = startedTime;
    }

    public String getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(String finishedTime) {
        this.finishedTime = finishedTime;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getBackupType() {
        return this.backupType;
    }

    public void setBackupType(Integer backupType) {
        this.backupType = backupType;
    }
}

