/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReceiver;
import org.exoplatform.services.jcr.ext.replication.async.ChangesSubscriber;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportClient;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportError;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportRequest;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportResponce;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportServer;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.transport.AbstractPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncChannelManager;
import org.exoplatform.services.jcr.ext.replication.async.transport.ChangesPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.ErrorPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.ExportChangesPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.GetExportPacket;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReceiverImpl
implements AsyncReceiver {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.AsyncReceiverImpl");
    protected final RemoteExportServer exportServer;
    protected ChangesSubscriber changesSubscriber;
    protected RemoteExportClient remoteExportListener;
    protected final List<Integer> otherParticipantsPriority;

    AsyncReceiverImpl(AsyncChannelManager channel, RemoteExportServer exportServer, List<Integer> otherParticipantsPriority) {
        this.exportServer = exportServer;
        this.otherParticipantsPriority = otherParticipantsPriority;
    }

    protected void onChanges(ChangesPacket packet, MemberAddress member) {
        Member mem = new Member(member, packet.getTransmitterPriority());
        if (this.changesSubscriber != null) {
            this.changesSubscriber.onChanges(packet, mem);
        } else {
            LOG.warn((Object)("Subscriber is not set. Changes from member " + member + " will be ignored. "));
        }
    }

    protected void onGetExport(GetExportPacket packet, MemberAddress member) {
        String nodeId = packet.getNodeId();
        RemoteExportRequest remoteGetEvent = new RemoteExportRequest(nodeId, member);
        this.exportServer.sendExport(remoteGetEvent);
    }

    @Override
    public void receive(AbstractPacket packet, MemberAddress address) {
        if (this.otherParticipantsPriority.contains(packet.getTransmitterPriority())) {
            switch (packet.getType()) {
                case 0: {
                    this.onGetExport((GetExportPacket)packet, address);
                    break;
                }
                case 1: {
                    ExportChangesPacket exportPacket = (ExportChangesPacket)packet;
                    Member member = new Member(address, exportPacket.getTransmitterPriority());
                    RemoteExportResponce eventFirst = new RemoteExportResponce(member, exportPacket.getPacketsCount(), exportPacket.getCRC(), exportPacket.getTimeStamp(), exportPacket.getBuffer(), exportPacket.getOffset());
                    this.remoteExportListener.onRemoteExport(eventFirst);
                    break;
                }
                case 5: {
                    ErrorPacket errorPacket = (ErrorPacket)packet;
                    RemoteExportError eventError = new RemoteExportError(errorPacket.getErrorMessage() + ". Error from member with priority " + errorPacket.getTransmitterPriority());
                    this.remoteExportListener.onRemoteError(eventError);
                    break;
                }
                case 2: {
                    this.onChanges((ChangesPacket)packet, address);
                }
            }
        } else {
            LOG.warn((Object)("Skipp packet from not configured participant : received priority = " + packet.getTransmitterPriority() + " ; Other participants priority = " + this.otherParticipantsPriority + "\nMember: " + address + "\nPacket: " + packet));
        }
    }

    @Override
    public void onError(MemberAddress sourceAddress) {
    }

    @Override
    public void removeRemoteExportListener() {
        this.remoteExportListener = null;
    }

    @Override
    public void setRemoteExportListener(RemoteExportClient listener) {
        this.remoteExportListener = listener;
    }

    @Override
    public void setChangesSubscriber(ChangesSubscriber subscriber) {
        this.changesSubscriber = subscriber;
    }
}

