/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.analyze;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.analyze.AbstractAnalyzer;
import org.exoplatform.services.jcr.ext.replication.async.resolve.ConflictResolver;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameAnalyzer
extends AbstractAnalyzer {
    public RenameAnalyzer(boolean localPriority, DataManager dataManager, NodeTypeDataManager ntManager) {
        super(localPriority, dataManager, ntManager);
    }

    @Override
    public void analyze(ItemState incomeChange, ChangesStorage<ItemState> local, ChangesStorage<ItemState> income, ConflictResolver confilictResolver) throws IOException, ClassCastException, ClassNotFoundException {
        ItemState incomeState = incomeChange;
        ItemState nextIncomeState = income.findNextState(incomeState, incomeState.getData().getIdentifier());
        QPath incNodePath = incomeState.getData().isNode() ? incomeState.getData().getQPath() : incomeState.getData().getQPath().makeParentPath();
        QPath nextIncNodePath = nextIncomeState.getData().isNode() ? nextIncomeState.getData().getQPath() : nextIncomeState.getData().getQPath().makeParentPath();
        Iterator<ItemState> liter = local.getChanges();
        block14: while (liter.hasNext()) {
            QPath nextLocalPath;
            QPath localPath;
            List<ItemState> updateSeq;
            ItemState nextLocalState;
            ItemState localState = liter.next();
            ItemData incomeData = incomeState.getData();
            ItemData localData = localState.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals((Object)Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals((Object)Constants.JCR_LOCKOWNER)) || localData.getIdentifier().equals("00exo0jcr0root0uuid0000000000000")) continue;
            if (this.isLocalPriority()) {
                block0 : switch (localState.getState()) {
                    case 1: {
                        if (localData.isNode()) {
                            if (!localData.getQPath().isDescendantOf(incNodePath) && !localData.getQPath().equals((Object)incNodePath) && !localData.getQPath().equals((Object)nextIncNodePath) && !nextIncNodePath.equals((Object)localData.getQPath()) && !nextIncNodePath.isDescendantOf(localData.getQPath())) break;
                            confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        if (!localData.getQPath().isDescendantOf(incNodePath)) break;
                        confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                        break;
                    }
                    case 4: {
                        if (localState.isPersisted()) {
                            if (localData.isNode()) {
                                if (!incNodePath.isDescendantOf(localData.getQPath()) && !incNodePath.equals((Object)localData.getQPath()) && !localData.getQPath().equals((Object)incNodePath) && !localData.getQPath().isDescendantOf(incNodePath) && !nextIncNodePath.isDescendantOf(localData.getQPath())) break;
                                confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break;
                            }
                            if (!incNodePath.isDescendantOf(localData.getQPath().makeParentPath()) && !incNodePath.equals((Object)localData.getQPath().makeParentPath()) && !localData.getQPath().makeParentPath().equals((Object)incNodePath) && !localData.getQPath().makeParentPath().isDescendantOf(incNodePath) && !nextIncNodePath.isDescendantOf(localData.getQPath().makeParentPath())) break;
                            confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            updateSeq = local.getUpdateSequence(localState);
                            for (ItemState item : updateSeq) {
                                if (!item.getData().getQPath().isDescendantOf(incNodePath) && !incNodePath.equals((Object)item.getData().getQPath()) && !incNodePath.isDescendantOf(item.getData().getQPath()) && !nextIncNodePath.isDescendantOf(item.getData().getQPath())) continue;
                                confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                                confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                                break block0;
                            }
                            continue block14;
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            localPath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                            QPath qPath = nextLocalPath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                            if (!localPath.isDescendantOf(incNodePath) && !localPath.equals((Object)incNodePath) && !nextIncNodePath.isDescendantOf(localPath) && !nextIncNodePath.equals((Object)nextLocalPath) && !nextLocalPath.isDescendantOf(incNodePath)) break;
                            confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                            confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                            break;
                        }
                    }
                    case 2: {
                        if (localData.isNode() || !localData.getQPath().isDescendantOf(incNodePath) && !localData.getQPath().equals((Object)incNodePath)) break;
                        confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 16: {
                        if (!localData.getQPath().equals((Object)incNodePath) && !localData.getQPath().isDescendantOf(incNodePath)) break;
                        confilictResolver.addAll(income.getUniquePathesByUUID(incomeData.isNode() ? incomeData.getIdentifier() : incomeData.getParentIdentifier()));
                        confilictResolver.addSkippedVSChanges(incomeData.getIdentifier());
                    }
                }
                continue;
            }
            switch (localState.getState()) {
                case 1: {
                    if (!incomeData.isNode()) break;
                    if (localData.getQPath().isDescendantOf(incNodePath) || localData.getQPath().equals((Object)incNodePath) || localData.getQPath().isDescendantOf(nextIncNodePath) || localData.getQPath().equals((Object)nextIncNodePath)) {
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    if (!localData.getQPath().isDescendantOf(incNodePath) && !localData.getQPath().equals((Object)incNodePath) && !localData.getQPath().isDescendantOf(nextIncNodePath) && !localData.getQPath().equals((Object)nextIncNodePath)) break;
                    confilictResolver.add(localData.getQPath());
                    break;
                }
                case 4: {
                    if (localState.isPersisted()) {
                        if (localData.isNode()) {
                            if (!incNodePath.isDescendantOf(localData.getQPath()) && !incNodePath.equals((Object)localData.getQPath()) && !localData.getQPath().equals((Object)incNodePath) && !localData.getQPath().isDescendantOf(incNodePath) && !nextIncNodePath.isDescendantOf(localData.getQPath())) break;
                            confilictResolver.add(localData.getQPath());
                            break;
                        }
                        if (!incNodePath.isDescendantOf(localData.getQPath().makeParentPath()) && !incNodePath.equals((Object)localData.getQPath().makeParentPath()) && !localData.getQPath().makeParentPath().equals((Object)incNodePath) && !localData.getQPath().makeParentPath().isDescendantOf(incNodePath) && !nextIncNodePath.isDescendantOf(localData.getQPath().makeParentPath())) break;
                        confilictResolver.add(localData.getQPath());
                        break;
                    }
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        updateSeq = local.getUpdateSequence(localState);
                        for (ItemState st : updateSeq) {
                            if (!st.getData().getQPath().isDescendantOf(incNodePath) && !incNodePath.equals((Object)st.getData().getQPath()) && !incNodePath.isDescendantOf(st.getData().getQPath()) && !nextIncNodePath.isDescendantOf(st.getData().getQPath())) continue;
                            confilictResolver.add(st.getData().getQPath());
                        }
                        continue block14;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        localPath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                        QPath qPath = nextLocalPath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                        if (!localPath.isDescendantOf(incNodePath) && !localPath.equals((Object)incNodePath) && !nextIncNodePath.isDescendantOf(localPath) && !nextIncNodePath.equals((Object)nextLocalPath) && !nextLocalPath.isDescendantOf(incNodePath)) break;
                        confilictResolver.addAll(local.getUniquePathesByUUID(localData.isNode() ? localData.getIdentifier() : localData.getParentIdentifier()));
                        break;
                    }
                }
                case 2: {
                    if (localData.isNode() || !localData.getQPath().isDescendantOf(incNodePath) && !localData.getQPath().equals((Object)incNodePath)) break;
                    confilictResolver.add(localData.getQPath());
                    break;
                }
                case 32: {
                    break;
                }
                case 16: {
                    if (!incomeData.isNode() || !localData.getQPath().equals((Object)incomeData.getQPath()) && !localData.getQPath().isDescendantOf(incNodePath)) break;
                    confilictResolver.add(localData.getQPath());
                }
            }
        }
    }
}

