/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.executor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;
import org.exoplatform.services.jcr.ext.replication.async.executor.AsyncReplicationExecutorException;
import org.exoplatform.services.jcr.ext.replication.async.executor.Member;
import org.exoplatform.services.jcr.ext.replication.test.ReplicationTestService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/async-replication-executor/")
@Produces(value={"text/plain"})
public class AsyncReplicationExecutor
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(ReplicationTestService.class);
    private final RepositoryService repositoryService;
    private final AsyncReplication asyncReplication;
    private final List<Member> members;

    public AsyncReplicationExecutor(AsyncReplication asyncReplication, RepositoryService repoService, InitParams params) {
        this.repositoryService = repoService;
        this.asyncReplication = asyncReplication;
        ObjectParameter parameter = params.getObjectParam("async-replication-executor-configuration");
        if (parameter == null) {
            throw new RuntimeException("async-replication-executor-configuration not specified");
        }
        ExecutorConf conf = (ExecutorConf)parameter.getObject();
        if (conf == null) {
            throw new RuntimeException("ExecutorConf not specified");
        }
        if (conf.getMembers().size() == 0) {
            throw new RuntimeException("members not specified");
        }
        this.members = conf.getMembers();
        log.info((Object)"AsyncReplicationExecutorService inited.");
    }

    public boolean synchronize() throws AsyncReplicationExecutorException {
        try {
            if (this.asyncReplication.synchronize()) {
                for (Member member : this.members) {
                    String sUrl = member.getUrl() + "/rest/async-replication-executor" + "/" + "start";
                    try {
                        Thread.sleep(2000L);
                        this.remoteStart(member, sUrl);
                    }
                    catch (ModuleException e) {
                        throw new AsyncReplicationExecutorException("Can't execute remote synchronization. Member : " + member, e);
                    }
                    catch (ParseException e) {
                        throw new AsyncReplicationExecutorException("Can't execute remote synchronization. Member : " + member, e);
                    }
                    catch (InterruptedException e) {
                        throw new AsyncReplicationExecutorException("Can't execute remote synchronization. Member : " + member, e);
                    }
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new AsyncReplicationExecutorException("Can't execute local synchronization.", e);
        }
        catch (RepositoryException e) {
            throw new AsyncReplicationExecutorException("Can't execute local synchronization.", e);
        }
        catch (RepositoryConfigurationException e) {
            throw new AsyncReplicationExecutorException("Can't execute local synchronization.", e);
        }
    }

    private void remoteStart(Member member, String sUrl) throws IOException, ModuleException, ParseException, AsyncReplicationExecutorException {
        URL url = new URL(sUrl);
        String userInfo = url.getUserInfo();
        if (userInfo == null || userInfo.split(":").length != 2) {
            throw new AsyncReplicationExecutorException("Fail remote start synchronization : the user name or password not not specified : " + member);
        }
        String userName = userInfo.split(":")[0];
        String password = userInfo.split(":")[1];
        HTTPConnection connection = new HTTPConnection(url);
        connection.removeModule(CookieModule.class);
        connection.addBasicAuthorization(member.getRealmName(), userName, password);
        HTTPResponse resp = connection.Get(url.getFile());
        if (resp.getStatusCode() != 200 || !"ok".equals(resp.getText())) {
            throw new AsyncReplicationExecutorException("Fail remote start synchronization : " + member + "\n" + resp.getText());
        }
    }

    @GET
    @Path(value="/start")
    public Response startSynchronization() {
        String result = "ok";
        try {
            this.asyncReplication.synchronize();
        }
        catch (Exception e) {
            result = "fail";
            log.error((Object)"Can't start synchronization", (Throwable)e);
        }
        return Response.ok((Object)result).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecutorConf {
        private List<Member> members = new ArrayList<Member>();

        public List<Member> getMembers() {
            return this.members;
        }

        public void setMembers(List<Member> members) {
            this.members = members;
        }
    }

    public static final class Constants {
        public static final int START_TIMEOUT = 2000;
        public static final String BASE_URL = "/rest/async-replication-executor";
        public static final String OK_RESULT = "ok";
        public static final String FAIL_RESULT = "fail";

        public final class OperationType {
            public static final String START_SYNCHRONIZATION = "start";
            public static final String START_SYNCHRONIZATION_ON_REPOSITORY = "startSynchronizationOnRepository";
            public static final String START_SYNCHRONIZATION_ON_WORKSPACE = "startSynchronizationOnWorkspace";
        }
    }
}

