/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangesStorage<T extends ItemState>
implements ChangesStorage<T> {
    @Override
    public String dump() throws ClassCastException, IOException, ClassNotFoundException {
        StringBuilder str = new StringBuilder();
        str.append("\r\nState\tID\t\t\t\t\tPersist\tEvent\tInternl\tPath\r\n");
        Iterator iter = this.getChanges();
        while (iter.hasNext()) {
            ItemState state = (ItemState)iter.next();
            str.append(ItemState.nameFromValue((int)state.getState()));
            str.append("\t");
            str.append(state.getData().getIdentifier());
            str.append("\t");
            str.append(state.isPersisted());
            str.append("\t");
            str.append(state.isEventFire());
            str.append("\t");
            str.append(state.isInternallyCreated());
            str.append("\t");
            str.append(state.getData().getQPath().getAsString());
            str.append("\r\n");
        }
        return str.toString();
    }

    @Override
    public T getItemState(NodeData parentData, QPathEntry name) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public T getItemState(String itemIdentifier) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public T findNextState(ItemState fromState, String identifier) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(fromState)) continue;
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (!inState.getData().getIdentifier().equals(identifier)) continue;
                return (T)inState;
            }
        }
        return null;
    }

    @Override
    public boolean hasState(ItemState state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!((ItemState)it.next()).isSame(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasState(String identifier, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            if (!ItemState.isSame((ItemState)((ItemState)it.next()), (String)identifier, (QPath)path, (int)state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> getChanges(QPath rootPath) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState item = (ItemState)it.next();
            if (!item.getData().getQPath().isDescendantOf(rootPath) && !item.getData().getQPath().equals((Object)rootPath)) continue;
            resultStates.add(item);
        }
        return resultStates;
    }

    @Override
    public List<T> getUpdateSequence(ItemState firstState) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(firstState)) continue;
            resultStates.add(state);
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (inState.getState() != 2 || !inState.getData().getQPath().getName().equals((Object)firstState.getData().getQPath().getName())) continue;
                resultStates.add(inState);
            }
        }
        return resultStates;
    }

    @Override
    public List<T> getMixinSequence(ItemState firstState) throws IOException, ClassCastException, ClassNotFoundException {
        ArrayList<ItemState> resultStates = new ArrayList<ItemState>();
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState state = (ItemState)it.next();
            if (!state.isSame(firstState)) continue;
            resultStates.add(state);
            while (it.hasNext()) {
                ItemState inState = (ItemState)it.next();
                if (!inState.isInternallyCreated()) continue;
                resultStates.add(inState);
            }
        }
        return resultStates;
    }

    @Override
    public QPath findVSChanges(String uuid) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            PropertyData prop;
            ItemState item = (ItemState)itemStates.next();
            if (!(!item.getData().isNode() & item.getData().getQPath().getName().equals((Object)Constants.JCR_VERSIONABLEUUID)) || (prop = (PropertyData)item.getData()).getValues().size() <= 0 || !uuid.equals(new String(((ValueData)prop.getValues().get(0)).getAsByteArray()))) continue;
            return item.getData().getQPath().makeParentPath();
        }
        return null;
    }

    @Override
    public String findVHProperty(String uuid) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            PropertyData prop;
            ItemState item = (ItemState)itemStates.next();
            if (item.getData().isNode() || !item.getData().getParentIdentifier().equals(uuid) || !item.getData().getQPath().getName().equals((Object)Constants.JCR_VERSIONHISTORY) || (prop = (PropertyData)item.getData()).getValues().size() <= 0) continue;
            return new String(((ValueData)prop.getValues().get(0)).getAsByteArray());
        }
        return null;
    }

    @Override
    public List<QPath> getUniquePathesByUUID(String identifier) throws IOException, ClassCastException, ClassNotFoundException {
        HashSet<QPath> index = new HashSet<QPath>();
        Iterator itemStates = this.getChanges();
        while (itemStates.hasNext()) {
            ItemState item = (ItemState)itemStates.next();
            if (!item.getData().getIdentifier().equals(identifier)) continue;
            index.add(item.getData().getQPath());
        }
        return new ArrayList<QPath>(index);
    }

    @Override
    public T findItemState(String identifier, QPath path, int state) throws IOException, ClassCastException, ClassNotFoundException {
        Iterator it = this.getChanges();
        while (it.hasNext()) {
            ItemState item = (ItemState)it.next();
            if (!ItemState.isSame((ItemState)item, (String)identifier, (QPath)path, (int)state)) continue;
            return (T)item;
        }
        return null;
    }
}

