/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.storage.AbstractChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.BufferedItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageIOException;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeItemStatesStorage<T extends ItemState>
extends AbstractChangesStorage<T>
implements EditableChangesStorage<T> {
    protected final Member member;
    protected final File storageDir;
    protected final List<ChangesStorage<T>> storages = new ArrayList<ChangesStorage<T>>();
    protected final ResourcesHolder resHolder;
    protected EditableChangesStorage<T> current;
    private final FileCleaner fileCleaner;
    private final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    public CompositeItemStatesStorage(File storageDir, Member member, ResourcesHolder resHolder, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.member = member;
        this.storageDir = storageDir;
        this.resHolder = resHolder;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    private EditableChangesStorage<T> current() {
        if (this.current == null) {
            this.current = new BufferedItemStatesStorage(this.storageDir, this.member, this.resHolder, this.fileCleaner, this.maxBufferSize, this.holder);
            this.storages.add(this.current);
        }
        return this.current;
    }

    @Override
    public void add(T change) throws IOException {
        this.current().add(change);
    }

    @Override
    public void addAll(ChangesStorage<T> changes) throws IOException {
        if (changes instanceof BufferedItemStatesStorage) {
            try {
                Iterator<T> chi = changes.getChanges();
                while (chi.hasNext()) {
                    this.add((ItemState)chi.next());
                }
            }
            catch (ClassCastException e) {
                throw new StorageIOException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageIOException(e.getMessage(), e);
            }
        } else {
            if (changes == this) {
                throw new StorageIOException("Cannot add itself to the storage");
            }
            if (changes instanceof CompositeItemStatesStorage) {
                CompositeItemStatesStorage c = (CompositeItemStatesStorage)changes;
                if (c.current != null && c.storages.size() == 1) {
                    try {
                        Iterator chi = c.current.getChanges();
                        while (chi.hasNext()) {
                            this.add((ItemState)chi.next());
                        }
                    }
                    catch (ClassCastException e) {
                        throw new StorageIOException(e.getMessage(), e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new StorageIOException(e.getMessage(), e);
                    }
                } else {
                    this.current = null;
                    this.storages.addAll(c.storages);
                }
            } else {
                this.current = null;
                this.storages.add(changes);
            }
        }
    }

    @Override
    public void delete() throws IOException {
        this.current = null;
        for (ChangesStorage<T> cs : this.storages) {
            cs.delete();
        }
        this.storages.clear();
    }

    @Override
    public Iterator<T> getChanges() throws IOException, ClassCastException, ClassNotFoundException {
        return new ItemStateIterator();
    }

    @Override
    public ChangesFile[] getChangesFile() {
        ArrayList<ChangesFile> cfiles = new ArrayList<ChangesFile>();
        for (ChangesStorage<T> cs : this.storages) {
            for (ChangesFile cf : cs.getChangesFile()) {
                cfiles.add(cf);
            }
        }
        return cfiles.toArray(new ChangesFile[cfiles.size()]);
    }

    @Override
    public int size() throws IOException, ClassCastException, ClassNotFoundException {
        int size = 0;
        Iterator<T> c = this.getChanges();
        while (c.hasNext()) {
            c.next();
            ++size;
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemStateIterator
    implements Iterator<T> {
        Iterator<ChangesStorage<T>> csIter;
        Iterator<T> sIter;
        T next;

        ItemStateIterator() throws ClassCastException, IOException, ClassNotFoundException {
            this.csIter = CompositeItemStatesStorage.this.storages.iterator();
            while (this.csIter.hasNext()) {
                this.sIter = this.csIter.next().getChanges();
                if (!this.sIter.hasNext()) continue;
                this.next = (ItemState)this.sIter.next();
                break;
            }
        }

        private T readNext() {
            if (this.next != null) {
                do {
                    if (this.sIter.hasNext()) {
                        return (ItemState)this.sIter.next();
                    }
                    if (this.csIter.hasNext()) {
                        try {
                            this.sIter = this.csIter.next().getChanges();
                        }
                        catch (ClassCastException e) {
                            throw new StorageRuntimeException(e.getMessage(), e);
                        }
                        catch (IOException e) {
                            throw new StorageRuntimeException(e.getMessage(), e);
                        }
                        catch (ClassNotFoundException e) {
                            throw new StorageRuntimeException(e.getMessage(), e);
                        }
                    } else {
                        this.sIter = null;
                    }
                } while (this.sIter != null);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            Object res = this.next;
            this.next = this.readNext();
            return res;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented!");
        }
    }
}

