/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesLogStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ReadOnlyIterator;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomeChangesStorage<T extends ItemState>
extends ChangesLogStorage<T>
implements MemberChangesStorage<T> {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.IncomeChangesStorage");
    protected SoftReference<List<T>> cache = new SoftReference<Object>(null);
    protected final Member member;

    public IncomeChangesStorage(ChangesStorage<T> income, Member member, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        super(Arrays.asList(income.getChangesFile()), fileCleaner, maxBufferSize, holder);
        this.member = member;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public Iterator<T> getChanges() throws IOException, ClassCastException, ClassNotFoundException {
        List<T> list = this.cache.get();
        if (list == null) {
            list = new ArrayList<T>();
            Iterator iter = super.getChanges();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            this.cache = new SoftReference<List<List<T>>>(list);
        }
        return new ReadOnlyIterator<T>(list.iterator());
    }

    @Override
    public void delete() throws IOException {
        super.delete();
    }

    @Override
    public int size() throws IOException, ClassNotFoundException {
        List<T> list = this.cache.get();
        if (list != null) {
            return list.size();
        }
        return super.size();
    }
}

