/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.ext.replication.async.storage.AbstractChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.Member;
import org.exoplatform.services.jcr.ext.replication.async.storage.MemberChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageIOException;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ItemStateReader;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ReaderSpoolFileHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemStatesStorage<T extends ItemState>
extends AbstractChangesStorage<T>
implements MemberChangesStorage<T> {
    protected static final Log LOG = ExoLogger.getLogger((String)"ext.ItemStatesStorage");
    private final ChangesFile storage;
    protected final Member member;
    private final FileCleaner fileCleaner;
    private final int maxBufferSize;
    private final ReaderSpoolFileHolder holder;

    public ItemStatesStorage(ChangesFile changes, Member member, FileCleaner fileCleaner, int maxBufferSize, ReaderSpoolFileHolder holder) {
        this.storage = changes;
        this.member = member;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = maxBufferSize;
        this.holder = holder;
    }

    @Override
    public int size() throws IOException, ClassNotFoundException, ClassCastException {
        Iterator<T> it = this.getChanges();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    @Override
    public Member getMember() {
        return this.member;
    }

    @Override
    public void delete() throws IOException {
        this.storage.delete();
    }

    @Override
    public ChangesFile[] getChangesFile() {
        return new ChangesFile[]{this.storage};
    }

    @Override
    public Iterator<T> getChanges() throws IOException, ClassCastException, ClassNotFoundException {
        return new ItemStateIterator(this.fileCleaner, this.maxBufferSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemStateIterator<S extends ItemState>
    implements Iterator<S> {
        private ObjectReader in;
        private S nextItem;
        private final FileCleaner fileCleaner;
        private final int maxBufferSize;

        public ItemStateIterator(FileCleaner fileCleaner, int maxBufferSize) throws IOException, ClassCastException, ClassNotFoundException {
            if (ItemStatesStorage.this.storage == null) {
                throw new NullPointerException("ChangesFile not exists.");
            }
            this.in = new ObjectReaderImpl(ItemStatesStorage.this.storage.getInputStream());
            this.nextItem = this.readNext();
            this.fileCleaner = fileCleaner;
            this.maxBufferSize = maxBufferSize;
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public S next() throws NoSuchElementException {
            if (this.nextItem == null) {
                throw new NoSuchElementException();
            }
            S retVal = this.nextItem;
            try {
                this.nextItem = this.readNext();
            }
            catch (IOException e) {
                throw new StorageRuntimeException(e.getMessage() + " file: " + ItemStatesStorage.this.storage, e);
            }
            catch (ClassNotFoundException e) {
                throw new StorageRuntimeException(e.getMessage() + " file: " + ItemStatesStorage.this.storage, e);
            }
            catch (ClassCastException e) {
                throw new StorageRuntimeException(e.getMessage() + " file: " + ItemStatesStorage.this.storage, e);
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not allowed!");
        }

        protected S readNext() throws IOException, ClassNotFoundException, ClassCastException {
            if (this.in != null) {
                try {
                    ItemStateReader rdr = new ItemStateReader(this.fileCleaner, this.maxBufferSize, ItemStatesStorage.this.holder);
                    return (S)rdr.read(this.in);
                }
                catch (EOFException e) {
                    this.in.close();
                    this.in = null;
                    return null;
                }
                catch (Throwable e) {
                    this.in.close();
                    this.in = null;
                    throw new StorageIOException(e.getMessage(), e);
                }
            }
            return null;
        }
    }
}

