/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.ext.replication.async.transport.MessagePacket;

public class GetExportPacket
extends MessagePacket {
    private String nodeId;

    public GetExportPacket(String nodeId, int priority) {
        super(0, priority);
        this.nodeId = nodeId;
    }

    public GetExportPacket() {
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.nodeId != null) {
            byte[] buf = this.nodeId.getBytes("UTF-8");
            out.writeInt(1);
            out.writeInt(buf.length);
            out.write(buf);
        } else {
            out.writeInt(-1);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.readInt() == 1) {
            int bufSize = in.readInt();
            byte[] buf = new byte[bufSize];
            in.readFully(buf);
            this.nodeId = new String(buf, "UTF-8");
        } else {
            this.nodeId = null;
        }
    }
}

