/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * Created by The eXo Platform SAS.
 * 
 * @author <a href="mailto:alex.reshetnyak@exoplatform.com.ua">Alex Reshetnyak</a>
 * @version $Id: FixupStream.java 31768 2009-05-14 09:35:43Z pnedonosko $
 */

public class FixupStream implements Externalizable {

  /**
   * serialVersionUID. Determinate the version of serialization.
   */
  private static final long serialVersionUID = 6453641729031051616L;

  /**
   * iItemStateId. Index of ItemState in ChangesLog.
   */
  private int               iItemStateId     = -1;

  /**
   * iValueDataId. Index of ValueData in ItemState.
   */
  private int               iValueDataId     = -1;

  /**
   * FixupStream constructor. Empty constructor is necessary to Externalizable.
   */
  public FixupStream() {
  }

  /**
   * FixupStream constructor.
   * 
   * @param itemState
   *          index of ItemState in ChangesLog
   * @param valueData
   *          index of ValueData in ItemState
   */
  public FixupStream(int itemState, int valueData) {
    this.iItemStateId = itemState;
    this.iValueDataId = valueData;
  }

  /**
   * getItemSateId.
   * 
   * @return int return the iItemStateId
   */
  public int getItemSateId() {
    return iItemStateId;
  }

  /**
   * getValueDataId.
   * 
   * @return int return the iValueDataId
   */
  public int getValueDataId() {
    return iValueDataId;
  }

  /**
   * compare.
   * 
   * @param fs
   *          FixupStream.
   * @return boolean return 'true' if this == fs
   */
  public boolean compare(FixupStream fs) {
    boolean b = true;
    if (fs.getItemSateId() != this.getItemSateId())
      b = false;
    if (fs.getValueDataId() != this.getValueDataId())
      b = false;
    return b;
  }

  /**
   * {@inheritDoc}
   */
  public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    iItemStateId = in.readInt();
    iValueDataId = in.readInt();
  }

  /**
   * {@inheritDoc}
   */
  public void writeExternal(ObjectOutput out) throws IOException {
    out.writeInt(iItemStateId);
    out.writeInt(iValueDataId);
  }
}
