/*
 * Copyright (C) 2003-2008 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.IOException;
import java.util.List;

import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.transport.MemberAddress;

/**
 * Created by The eXo Platform SAS.
 * 
 * <br/>Date: 12.12.2008
 * 
 * @author <a href="mailto:peter.nedonosko@exoplatform.com.ua">Peter Nedonosko</a>
 * @version $Id: AsyncTransmitter.java 27927 2009-02-05 13:07:25Z pnedonosko $
 */
public interface AsyncTransmitter {

  /**
   * Send changes.
   * 
   * @param changes
   * @param subscribers
   * @throws IOException
   */
  void sendChanges(ChangesFile[] changes, List<MemberAddress> subscribers) throws IOException;
  
  /**
   * Send changes file.
   *
   * @param changes
   * @param subscribers
   * @throws IOException
   */
  void sendChanges(ChangesFile changes, List<MemberAddress> subscribers, int totalFiles) throws IOException;

  /**
   * Send Get Export request.
   * 
   * @param nodeId
   * @param address
   * @throws IOException
   */
  void sendGetExport(String nodeId, MemberAddress address) throws IOException;

  /**
   * Send export response.
   * 
   * @param changes
   * @param address
   * @throws IOException
   */
  void sendExport(ChangesFile changes, MemberAddress address) throws IOException;

  /**
   * sendError.
   *
   * @param error
   * @param address
   * @throws IOException
   */
  void sendError(String error, MemberAddress address) throws IOException;
  
  /**
   * send 'Done'.
   *
   * @throws IOException
   */
  void sendMerge() throws IOException;
  
  /**
   * send 'Cancel'.
   *
   * @throws IOException
   */
  void sendCancel() throws IOException;

}
