/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;

public class UserHandlerImpl
extends CommonHandler
implements UserHandler {
    public static final String EXO_CREATED_DATE = "exo:createdDate";
    public static final String EXO_EMAIL = "exo:email";
    public static final String EXO_FIRST_NAME = "exo:firstName";
    public static final String EXO_LAST_LOGIN_TIME = "exo:lastLoginTime";
    public static final String EXO_LAST_NAME = "exo:lastName";
    public static final String EXO_MEMBERSHIP = "exo:membership";
    public static final String EXO_PASSWORD = "exo:password";
    public static final String EXO_PROFILE = "exo:profile";
    public static final String STORAGE_EXO_USERS = "exo:users";
    protected final List<UserEventListener> listeners = new ArrayList<UserEventListener>();
    protected final JCROrganizationServiceImpl service;
    protected static Log log = ExoLogger.getLogger((String)"jcr.UserHandlerImpl");

    UserHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    public void addUserEventListener(UserEventListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            boolean bl = this.authenticate(session, username, password);
            return bl;
        }
        finally {
            session.logout();
        }
    }

    private boolean authenticate(Session session, String username, String password) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.authenticate method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS + "/" + username);
            boolean authenticated = this.readStringProperty(uNode, EXO_PASSWORD).equals(password);
            if (authenticated) {
                uNode.setProperty(EXO_LAST_LOGIN_TIME, Calendar.getInstance());
            }
            return authenticated;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not authenticate user '" + username + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createUser(session, user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createUser(Session session, User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUser method is started");
        }
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS);
            Node uNode = storageNode.addNode(user.getUserName());
            if (user.getCreatedDate() == null) {
                Calendar calendar = Calendar.getInstance();
                user.setCreatedDate(calendar.getTime());
            }
            if (broadcast) {
                this.preSave(user, true);
            }
            this.writeObjectToNode(user, uNode);
            session.save();
            if (broadcast) {
                this.postSave(user, true);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create user '" + user.getUserName() + "'", e);
        }
    }

    public User createUserInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance() method is started");
        }
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.createUserInstance(String) method is started");
        }
        return new UserImpl(username);
    }

    User findUserByName(Session session, String userName) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUserByName method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS + "/" + userName);
            return this.readObjectFromNode(uNode);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find user '" + userName + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUserByName(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            User user = this.findUserByName(session, userName);
            return user;
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageList findUsers(org.exoplatform.services.organization.Query query) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            PageList pageList = this.findUsers(session, query);
            return pageList;
        }
        finally {
            session.logout();
        }
    }

    private PageList findUsers(Session session, org.exoplatform.services.organization.Query query) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUsers method is started");
        }
        try {
            String where = "jcr:path LIKE '%'";
            if (query.getEmail() != null) {
                where = where + " AND " + "exo:email LIKE '" + query.getEmail().replace('*', '%') + "'";
            }
            if (query.getFirstName() != null) {
                where = where + " AND " + "exo:firstName LIKE '" + query.getFirstName().replace('*', '%') + "'";
            }
            if (query.getLastName() != null) {
                where = where + " AND " + "exo:lastName LIKE '" + query.getLastName().replace('*', '%') + "'";
            }
            ArrayList<User> types = new ArrayList<User>();
            String statement = "select * from exo:user " + (where.length() == 0 ? "" : "where " + where);
            Query uQuery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult uRes = uQuery.execute();
            NodeIterator uNodes = uRes.getNodes();
            while (uNodes.hasNext()) {
                Node uNode = uNodes.nextNode();
                if (query.getUserName() != null && !this.isNameLike(uNode.getName(), query.getUserName())) continue;
                Date lastLoginTime = this.readDateProperty(uNode, EXO_LAST_LOGIN_TIME);
                if (query.getFromLoginDate() != null && (lastLoginTime == null || query.getFromLoginDate().getTime() > lastLoginTime.getTime()) || query.getToLoginDate() != null && (lastLoginTime == null || query.getToLoginDate().getTime() < lastLoginTime.getTime())) continue;
                types.add(this.readObjectFromNode(uNode));
            }
            return new ObjectPageList(types, 10);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find users", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageList findUsersByGroup(String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            PageList pageList = this.findUsersByGroup(session, groupId);
            return pageList;
        }
        finally {
            session.logout();
        }
    }

    private PageList findUsersByGroup(Session session, String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.findUsersByGroup method is started");
        }
        ArrayList<User> users = new ArrayList<User>();
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:groups" + groupId);
            String statement = "select * from exo:userMembership where exo:group='" + gNode.getUUID() + "'";
            Query mquery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult mres = mquery.execute();
            NodeIterator membs = mres.getNodes();
            while (membs.hasNext()) {
                users.add(this.readObjectFromNode(membs.nextNode().getParent()));
            }
            return new ObjectPageList(users, 10);
        }
        catch (PathNotFoundException e) {
            return new ObjectPageList(users, 10);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find users by group '" + groupId + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageList getUserPageList(int pageSize) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            PageList pageList = this.getUserPageList(session, pageSize);
            return pageList;
        }
        finally {
            session.logout();
        }
    }

    private PageList getUserPageList(Session session, int pageSize) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.getUserPageList method is started");
        }
        try {
            ArrayList<User> types = new ArrayList<User>();
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS);
            NodeIterator uNodes = storageNode.getNodes();
            while (uNodes.hasNext()) {
                types.add(this.readObjectFromNode(uNodes.nextNode()));
            }
            return new ObjectPageList(types, pageSize);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get user page list", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User removeUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            User user = this.removeUser(session, userName, broadcast);
            return user;
        }
        finally {
            session.logout();
        }
    }

    private User removeUser(Session session, String userName, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.removeUser method is started");
        }
        try {
            Node uNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_EXO_USERS + "/" + userName);
            User user = this.readObjectFromNode(uNode);
            if (broadcast) {
                this.preDelete(user);
            }
            uNode.remove();
            session.save();
            if (broadcast) {
                this.postDelete(user);
            }
            return user;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove user '" + userName + "'", e);
        }
    }

    public void removeUserEventListener(UserEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(User user, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.saveUser(session, user, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void saveUser(Session session, User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User.saveUser method is started");
        }
        try {
            UserImpl userImpl = (UserImpl)user;
            String userUUID = userImpl.getUUId() != null ? userImpl.getUUId() : ((UserImpl)this.findUserByName(session, user.getUserName())).getUUId();
            Node uNode = session.getNodeByUUID(userUUID);
            String srcPath = uNode.getPath();
            int pos = srcPath.lastIndexOf(47);
            String prevName = srcPath.substring(pos + 1);
            if (!prevName.equals(user.getUserName())) {
                String destPath = srcPath.substring(0, pos) + "/" + user.getUserName();
                session.move(srcPath, destPath);
                uNode = (Node)session.getItem(destPath);
            }
            if (broadcast) {
                this.preSave(user, false);
            }
            this.writeObjectToNode(user, uNode);
            session.save();
            if (broadcast) {
                this.postSave(user, false);
            }
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save user '" + user.getUserName() + "'", e);
        }
    }

    private User readObjectFromNode(Node node) throws Exception {
        try {
            UserImpl user = new UserImpl(node.getName(), node.getUUID());
            user.setCreatedDate(this.readDateProperty(node, EXO_CREATED_DATE));
            user.setLastLoginTime(this.readDateProperty(node, EXO_LAST_LOGIN_TIME));
            user.setEmail(this.readStringProperty(node, EXO_EMAIL));
            user.setPassword(this.readStringProperty(node, EXO_PASSWORD));
            user.setFirstName(this.readStringProperty(node, EXO_FIRST_NAME));
            user.setLastName(this.readStringProperty(node, EXO_LAST_NAME));
            return user;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read user properties", e);
        }
    }

    private void writeObjectToNode(User user, Node node) throws Exception {
        try {
            Calendar calendar = null;
            node.setProperty(EXO_EMAIL, user.getEmail());
            node.setProperty(EXO_FIRST_NAME, user.getFirstName());
            node.setProperty(EXO_LAST_NAME, user.getLastName());
            node.setProperty(EXO_PASSWORD, user.getPassword());
            if (user.getLastLoginTime() == null) {
                node.setProperty(EXO_LAST_LOGIN_TIME, calendar);
            } else {
                calendar = Calendar.getInstance();
                calendar.setTime(user.getLastLoginTime());
                node.setProperty(EXO_LAST_LOGIN_TIME, calendar);
            }
            calendar = Calendar.getInstance();
            calendar.setTime(user.getCreatedDate());
            node.setProperty(EXO_CREATED_DATE, calendar);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write user properties", e);
        }
    }

    private void preSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preSave(user, isNew);
        }
    }

    private void postSave(User user, boolean isNew) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postSave(user, isNew);
        }
    }

    private void preDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.preDelete(user);
        }
    }

    private void postDelete(User user) throws Exception {
        for (UserEventListener listener : this.listeners) {
            listener.postDelete(user);
        }
    }

    private String removeAsterix(String str) {
        if (str.startsWith("*")) {
            str = str.substring(1);
        }
        if (str.endsWith("*")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private boolean isNameLike(String userName, String queryName) {
        boolean startWith = false;
        boolean endWith = false;
        if (queryName.startsWith("*")) {
            startWith = true;
            queryName = queryName.substring(1);
        }
        if (queryName.endsWith("*")) {
            endWith = true;
            queryName = queryName.substring(0, queryName.length() - 1);
        }
        if (startWith && endWith) {
            return userName.indexOf(queryName) != -1;
        }
        if (startWith) {
            return userName.startsWith(queryName);
        }
        if (endWith) {
            return userName.endsWith(queryName);
        }
        return userName.equals(queryName);
    }
}

